/*
 * Decompiled with CFR 0.152.
 */
package cofh.requack.sort;

import cofh.requack.annotation.Requires;
import cofh.requack.sort.CyclePresentException;
import cofh.requack.sort.StronglyConnectedComponentDetector;
import com.google.common.base.Preconditions;
import com.google.common.graph.Graph;
import java.util.AbstractCollection;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.PriorityQueue;
import java.util.Set;
import javax.annotation.Nullable;

@Requires(value="com.google.guava:guava")
public final class TopologicalSort {
    public static <T> List<T> topologicalSort(Graph<T> graph, @Nullable Comparator<? super T> comparator) throws IllegalArgumentException {
        Preconditions.checkArgument((boolean)graph.isDirected(), (Object)"Cannot topologically sort an undirected graph!");
        Preconditions.checkArgument((!graph.allowsSelfLoops() ? 1 : 0) != 0, (Object)"Cannot topologically sort a graph with self loops!");
        AbstractCollection queue = comparator == null ? new ArrayDeque() : new PriorityQueue<T>(comparator);
        HashMap<Object, Integer> degrees = new HashMap<Object, Integer>();
        ArrayList results = new ArrayList();
        for (Object node2 : graph.nodes()) {
            int degree2 = graph.inDegree(node2);
            if (degree2 == 0) {
                queue.add(node2);
                continue;
            }
            degrees.put(node2, degree2);
        }
        while (!queue.isEmpty()) {
            Object current = queue.remove();
            results.add(current);
            for (Object successor : graph.successors(current)) {
                int updated = degrees.compute(successor, (node, degree) -> Objects.requireNonNull(degree, () -> "Invalid degree present for " + node) - 1);
                if (updated != 0) continue;
                queue.add(successor);
                degrees.remove(successor);
            }
        }
        if (!degrees.isEmpty()) {
            Set<Set<T>> components = new StronglyConnectedComponentDetector<T>(graph).getComponents();
            components.removeIf(set -> set.size() < 2);
            TopologicalSort.throwCyclePresentException(components);
        }
        return results;
    }

    private static <T> void throwCyclePresentException(Set<Set<T>> components) {
        throw new CyclePresentException(components);
    }
}

