/*
 * Decompiled with CFR 0.152.
 */
package dev.kostromdan.mods.crash_assistant.app.gui;

import dev.kostromdan.mods.crash_assistant.app.CrashAssistantApp;
import dev.kostromdan.mods.crash_assistant.app.gui.CrashAssistantGUI;
import dev.kostromdan.mods.crash_assistant.common_config.config.CrashAssistantLocalConfig;
import dev.kostromdan.mods.crash_assistant.common_config.lang.LanguageProvider;
import dev.kostromdan.mods.crash_assistant.common_config.utils.JavaBinaryLocator;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class IntegratedGPUWarning
extends JFrame {
    public static boolean isCurrentlyDisplayed = false;

    public IntegratedGPUWarning(String integratedGPU, List<String> dedicatedGPUs) {
        super(LanguageProvider.get((String)"gui.integrated_gpu"));
        String content = LanguageProvider.get((String)"warnings.integrated_gpu").replace("$I_GPU$", integratedGPU).replace("$D_GPUS$", String.join((CharSequence)"\n", dedicatedGPUs)).replace("$JAVA_PATH$", Paths.get(JavaBinaryLocator.getJavaBinary(), new String[0]).toAbsolutePath().toString());
        JEditorPane editorPane = CrashAssistantGUI.getEditorPane(content, false);
        JPanel textPanel = new JPanel(new BorderLayout());
        textPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY, 1), BorderFactory.createEmptyBorder(10, 10, 10, 10)));
        textPanel.add((Component)editorPane, "Center");
        JCheckBox dontShowAgainCheck = new JCheckBox(LanguageProvider.get((String)"gui.intel_corrupted_dont_show_again"));
        dontShowAgainCheck.addActionListener(e -> {
            CrashAssistantLocalConfig.set((String)"integrated_gpu.dont_show_again", (Object)dontShowAgainCheck.isSelected());
            CrashAssistantApp.LOGGER.info("Don't show again checkbox switched: {}", (Object)dontShowAgainCheck.isSelected());
        });
        JButton okButton = new JButton("OK");
        okButton.addActionListener(e -> this.dispose());
        JPanel bottomPanel = new JPanel(new FlowLayout(1, 10, 10));
        bottomPanel.add(dontShowAgainCheck);
        bottomPanel.add(okButton);
        JPanel mainPanel = new JPanel(new BorderLayout(10, 10));
        mainPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        mainPanel.add((Component)textPanel, "Center");
        mainPanel.add((Component)bottomPanel, "South");
        this.setContentPane(mainPanel);
        this.pack();
        this.setDefaultCloseOperation(2);
        this.setLocationRelativeTo(null);
        this.setAlwaysOnTop(true);
    }

    public static void showIfNotDisabled(String integratedGPU, List<String> dedicatedGPUs) {
        isCurrentlyDisplayed = true;
        SwingUtilities.invokeLater(() -> {
            CrashAssistantApp.LOGGER.warn("Showing IntegratedGPUWarning.");
            IntegratedGPUWarning frame = new IntegratedGPUWarning(integratedGPU, dedicatedGPUs);
            frame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent e) {
                    CrashAssistantApp.LOGGER.warn("Shown IntegratedGPUWarning.");
                    isCurrentlyDisplayed = false;
                }
            });
            frame.setVisible(true);
        });
        IntegratedGPUWarning.awaitShown();
    }

    public static void awaitShown() {
        while (isCurrentlyDisplayed) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void main(String[] args) {
        IntegratedGPUWarning.showIfNotDisabled("Intel HD Graphics", Arrays.asList("NVIDIA GTX 1080", "AMD Radeon RX 580"));
    }
}

