/*
 * Decompiled with CFR 0.152.
 */
package dev.kostromdan.mods.crash_assistant.app.gui;

import dev.kostromdan.mods.crash_assistant.app.CrashAssistantApp;
import dev.kostromdan.mods.crash_assistant.app.gui.ControlPanel;
import dev.kostromdan.mods.crash_assistant.app.gui.CrashAssistantGUI;
import dev.kostromdan.mods.crash_assistant.app.logs_analyser.KnownCrashReasonMessage;
import dev.kostromdan.mods.crash_assistant.app.utils.IntelCorruptedProcessorChecker;
import dev.kostromdan.mods.crash_assistant.common_config.config.CrashAssistantConfig;
import dev.kostromdan.mods.crash_assistant.common_config.config.CrashAssistantLocalConfig;
import dev.kostromdan.mods.crash_assistant.common_config.lang.LanguageProvider;
import dev.kostromdan.mods.crash_assistant.common_config.lang.LinksProvider;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingWorker;

public class IntelChipBugWarning {
    public static final String GIF_URL = "https://kostromdan.github.io/Crash-Assistant/assets/intel_bug.gif?raw=true";
    public static final Path LOCAL_GIF_PATH = Paths.get("local", "crash_assistant", "intel_bug.gif");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void showIfAffected(boolean debug) {
        Class<KnownCrashReasonMessage> clazz = KnownCrashReasonMessage.class;
        synchronized (KnownCrashReasonMessage.class) {
            if (!CrashAssistantConfig.getBoolean((String)"intel_corrupted.enabled")) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            if (!IntelCorruptedProcessorChecker.isAffectedProcessor() && !debug) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            if (Objects.equals(CrashAssistantLocalConfig.get((String)"intel_corrupted.dont_show_again"), true)) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            boolean showGif = CrashAssistantConfig.getBoolean((String)"intel_corrupted.show_gif");
            CrashAssistantApp.LOGGER.info("Showing IntelChipBugWarning");
            ControlPanel.stopMovingToTop = true;
            JDialog dialog = new JDialog((Frame)null, LanguageProvider.get((String)"gui.intel_corrupted_title"), true);
            dialog.setDefaultCloseOperation(2);
            JPanel mainPanel = new JPanel(new GridBagLayout());
            mainPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.insets = new Insets(3, 3, 3, 3);
            int colIndex = 0;
            JLabel gifLabel = null;
            int gifWidth = 211;
            int gifHeight = 374;
            if (showGif) {
                JPanel gifPanel = new JPanel(new BorderLayout());
                gifPanel.setPreferredSize(new Dimension(gifWidth, gifHeight));
                gifPanel.setMinimumSize(new Dimension(gifWidth, gifHeight));
                gifPanel.setMaximumSize(new Dimension(gifWidth, gifHeight));
                gifPanel.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
                gifLabel = new JLabel("GIF", 0);
                gifLabel.setHorizontalAlignment(0);
                gifLabel.setVerticalAlignment(0);
                gifPanel.add((Component)gifLabel, "Center");
                gbc.gridx = 0;
                gbc.gridy = 0;
                gbc.gridheight = 2;
                gbc.weightx = 0.0;
                gbc.weighty = 1.0;
                gbc.fill = 3;
                gbc.anchor = 10;
                mainPanel.add((Component)gifPanel, gbc);
                colIndex = 1;
                final JLabel finalGifLabel = gifLabel;
                new SwingWorker<ImageIcon, Void>(){

                    @Override
                    protected ImageIcon doInBackground() throws Exception {
                        LOCAL_GIF_PATH.getParent().toFile().mkdirs();
                        if (!LOCAL_GIF_PATH.toFile().isFile()) {
                            try (InputStream in = new URL(IntelChipBugWarning.GIF_URL).openStream();
                                 FileOutputStream out = new FileOutputStream(LOCAL_GIF_PATH.toFile());){
                                int bytesRead;
                                byte[] buffer = new byte[1024];
                                while ((bytesRead = in.read(buffer)) != -1) {
                                    out.write(buffer, 0, bytesRead);
                                }
                            }
                        }
                        Image image = Toolkit.getDefaultToolkit().createImage(LOCAL_GIF_PATH.toFile().getAbsolutePath());
                        MediaTracker tracker = new MediaTracker(new JPanel());
                        tracker.addImage(image, 0);
                        tracker.waitForAll();
                        return new ImageIcon(image);
                    }

                    @Override
                    protected void done() {
                        try {
                            ImageIcon loadedIcon = (ImageIcon)this.get();
                            finalGifLabel.setText(null);
                            finalGifLabel.setIcon(loadedIcon);
                        }
                        catch (Exception e) {
                            CrashAssistantApp.LOGGER.error("Error loading GIF: ", (Throwable)e);
                            finalGifLabel.setText("Failed to load GIF");
                        }
                    }
                }.execute();
            }
            JEditorPane textPane = CrashAssistantGUI.getEditorPane(LanguageProvider.get((String)"gui.intel_corrupted_msg", (HashMap)new HashMap<String, String>(){
                {
                    this.put("$LINK.INTEL_CHIP_BUG_FAQ$", "FAQ");
                }
            }), true);
            textPane.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
            gbc.gridx = colIndex;
            gbc.gridy = 0;
            gbc.gridheight = 1;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.fill = 1;
            gbc.anchor = 10;
            mainPanel.add((Component)textPane, gbc);
            JPanel buttonPanel = new JPanel(new FlowLayout(1, 5, 5));
            JButton readMoreButton = new JButton(LanguageProvider.get((String)"gui.intel_corrupted_read_more"));
            readMoreButton.addActionListener(e -> {
                try {
                    Desktop.getDesktop().browse(new URI(LinksProvider.INTEL_CHIP_BUG_FAQ.getLink()));
                }
                catch (Exception ex) {
                    CrashAssistantApp.LOGGER.error("Error opening URL: ", (Throwable)ex);
                }
            });
            JButton okButton = new JButton("OK");
            okButton.addActionListener(e -> dialog.dispose());
            buttonPanel.add(readMoreButton);
            buttonPanel.add(okButton);
            JPanel bottomPanel = new JPanel(new BorderLayout());
            bottomPanel.add((Component)buttonPanel, "Center");
            JCheckBox dontShowAgainCheck = new JCheckBox(LanguageProvider.get((String)"gui.intel_corrupted_dont_show_again"));
            dontShowAgainCheck.addActionListener(e -> CrashAssistantLocalConfig.set((String)"intel_corrupted.dont_show_again", (Object)dontShowAgainCheck.isSelected()));
            bottomPanel.add((Component)dontShowAgainCheck, "West");
            gbc.gridx = colIndex;
            gbc.gridy = 1;
            gbc.gridheight = 1;
            gbc.weightx = 1.0;
            gbc.weighty = 0.0;
            gbc.fill = 0;
            gbc.anchor = 10;
            mainPanel.add((Component)bottomPanel, gbc);
            dialog.setContentPane(mainPanel);
            dialog.pack();
            dialog.setSize(800 - (showGif ? 0 : gifWidth), Math.max(dialog.getPreferredSize().height, 439));
            dialog.setLocationRelativeTo(null);
            if (debug) {
                dialog.setAlwaysOnTop(true);
            }
            dialog.setVisible(true);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            CrashAssistantApp.LOGGER.info("Shown IntelChipBugWarning");
            return;
        }
    }

    public static void main(String[] args) {
        IntelChipBugWarning.showIfAffected(true);
    }
}

