/*
 * Decompiled with CFR 0.152.
 */
package dev.kostromdan.mods.crash_assistant.app.logs_analyser;

import dev.kostromdan.mods.crash_assistant.app.CrashAssistantApp;
import dev.kostromdan.mods.crash_assistant.app.logs_analyser.Log;
import dev.kostromdan.mods.crash_assistant.app.logs_analyser.LogReader;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LauncherLogReader
extends LogReader {
    private static final List<String> MinecraftLauncherLogNames = Arrays.asList("MinecraftLauncher: launcher_log.txt", "CurseForge: launcher_log.txt");
    private Integer exitCode = null;

    public Integer getExitCode() {
        return this.exitCode;
    }

    public LauncherLogReader(Log log) {
        super(log);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized List<String> getAllLinesList() {
        LauncherLogReader launcherLogReader = this;
        synchronized (launcherLogReader) {
            if (this.allLinesListCached == null) {
                this.allLinesListCached = new ArrayList();
                this.allLinesListCached.addAll(this.firstLines);
                if (this.lastLines != null) {
                    this.allLinesListCached.addAll(this.lastLines);
                }
                this.cutLauncherLog();
            }
            return this.allLinesListCached;
        }
    }

    private void cutLauncherLog() {
        if (MinecraftLauncherLogNames.contains(this.log.getName())) {
            this.cutVanillaLauncherLog();
            return;
        }
        if (Objects.equals(this.log.getName(), "launcher_log.txt")) {
            return;
        }
        this.allLinesListCached = Collections.singletonList("");
    }

    private void cutVanillaLauncherLog() {
        int launchedLine = -1;
        Integer launchedGameId = null;
        int stoppedLine = -1;
        Integer stoppedGameId = null;
        long lastLineEpochMillis = -1L;
        block0: for (int i = this.allLinesListCached.size() - 1; i >= 0; --i) {
            String line = (String)this.allLinesListCached.get(i);
            if (lastLineEpochMillis == -1L && line.contains("MinecraftJavaLoggingContext")) {
                Long parsedMillis = LauncherLogReader.getEpochMillisFromMinecraftLauncherLog(line);
                long l = lastLineEpochMillis = parsedMillis == null ? -2L : parsedMillis;
            }
            if (stoppedLine == -1 && line.contains("Game closed with id ")) {
                stoppedLine = i;
                stoppedGameId = Integer.parseInt(line.split("Game closed with id ")[1]);
                if (i - 1 < 0) continue;
                for (int j = i - 1; j >= 0; --j) {
                    String exitCodeStr = (String)this.allLinesListCached.get(i - 1);
                    if (!exitCodeStr.contains("Launcher/monitor (Process Monitor)") || !exitCodeStr.contains("with exit code ")) continue;
                    this.exitCode = Integer.parseInt(exitCodeStr.split("with exit code ")[1]);
                    continue block0;
                }
                continue;
            }
            if (launchedLine != -1 || !line.contains("Starting game with token ")) continue;
            launchedLine = i;
            launchedGameId = Integer.parseInt(line.split("Starting game with token ")[1]);
            break;
        }
        if (lastLineEpochMillis > 0L && CrashAssistantApp.parentStarted > lastLineEpochMillis) {
            this.allLinesListCached = Collections.singletonList("");
            return;
        }
        if (launchedGameId != null && launchedGameId.equals(stoppedGameId) && stoppedLine > launchedLine) {
            this.allLinesListCached = this.allLinesListCached.subList(launchedLine, stoppedLine + 1);
            return;
        }
        if (this.lastLines == null) {
            if (launchedLine != -1 && stoppedLine == -1) {
                this.allLinesListCached = this.allLinesListCached.subList(launchedLine, this.allLinesListCached.size());
                return;
            }
        } else if (stoppedLine != -1 && launchedLine != -1) {
            int launchedLineIndexInLastLines = this.lastLines.lastIndexOf(this.allLinesListCached.get(launchedLine));
            int stoppedLineIndexInLastLines = this.lastLines.lastIndexOf(this.allLinesListCached.get(stoppedLine));
            if (launchedLineIndexInLastLines == -1 || stoppedLineIndexInLastLines != -1) {
                this.allLinesListCached = this.lastLines.subList(0, stoppedLineIndexInLastLines + 1);
                return;
            }
        }
        this.allLinesListCached = Collections.singletonList("");
    }

    public static Long getEpochMillisFromMinecraftLauncherLog(String logLine) {
        Matcher matcher = Pattern.compile("\\[Info: (\\d{4}-\\d{2}-\\d{2} \\d{2}:\\d{2}:\\d{2}\\.(\\d+)):").matcher(logLine);
        if (matcher.find()) {
            try {
                String dateTimePart = matcher.group(1);
                String fractionalPart = matcher.group(2);
                fractionalPart = fractionalPart.length() > 6 ? fractionalPart.substring(0, 6) : String.format("%-6s", fractionalPart).replace(' ', '0');
                String normalizedDateTime = dateTimePart.substring(0, dateTimePart.lastIndexOf(46) + 1) + fractionalPart;
                ZonedDateTime utcDateTime = LocalDateTime.parse(normalizedDateTime, DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSSSSS")).atZone(ZoneOffset.UTC);
                return utcDateTime.withZoneSameInstant(ZoneId.systemDefault()).toInstant().toEpochMilli();
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }
}

