/*
 * Decompiled with CFR 0.152.
 */
package dev.kostromdan.mods.crash_assistant.app.logs_analyser;

import dev.kostromdan.mods.crash_assistant.app.CrashAssistantApp;
import dev.kostromdan.mods.crash_assistant.app.logs_analyser.Log;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.time.Instant;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.io.input.ReversedLinesFileReader;

public class LogReader {
    static final int maxUploadLines = 25000;
    static final int maxUploadLength = 0xA00000;
    int countedLines = 0;
    boolean lineCountInterrupted = false;
    List<String> firstLines = new ArrayList<String>(25000);
    List<String> lastLines = null;
    List<String> allLinesListCached;
    String allLinesStringCached;
    Log log;
    boolean isLogProcessed = false;
    long sizeOnLastRead = -1L;

    public LogReader(Log log) {
        this.log = log;
    }

    public synchronized void readLogFile(boolean checkUpdated) throws IOException {
        String line;
        if (this.isLogProcessed && (!checkUpdated || Files.size(this.log.getPath()) == this.sizeOnLastRead)) {
            return;
        }
        this.sizeOnLastRead = Files.size(this.log.getPath());
        this.countedLines = 0;
        this.lineCountInterrupted = false;
        this.lastLines = null;
        this.firstLines = new ArrayList<String>(25000);
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.log.getFile()), StandardCharsets.UTF_8));){
            int length = 0;
            while ((line = reader.readLine()) != null && this.countedLines < 25000 && length < 0xA00000) {
                if (line.isEmpty()) continue;
                this.firstLines.add(line);
                length += line.length() + 1;
                ++this.countedLines;
            }
            if (line == null) {
                this.isLogProcessed = true;
                return;
            }
            long timeCountStarted = Instant.now().toEpochMilli();
            while (reader.readLine() != null) {
                ++this.countedLines;
                if (this.countedLines % 100 != 0 || Instant.now().toEpochMilli() - timeCountStarted < 1000L) continue;
                this.lineCountInterrupted = true;
                break;
            }
        }
        this.lastLines = new LinkedList<String>();
        try (ReversedLinesFileReader reversedReader = this.createReversedLinesFileReader();){
            int count = 0;
            int length = 0;
            while ((line = reversedReader.readLine()) != null && count < 25000 && length < 0xA00000) {
                if (line.isEmpty()) continue;
                this.lastLines.add(0, line);
                length += line.length() + 1;
                ++count;
            }
            if (length > 0xA00000) {
                this.lastLines.remove(0);
            }
        }
        this.isLogProcessed = true;
    }

    public synchronized void readLogFileSafe() {
        try {
            this.readLogFile(false);
        }
        catch (IOException e) {
            CrashAssistantApp.LOGGER.info("Error processing log file", (Throwable)e);
        }
    }

    private ReversedLinesFileReader createReversedLinesFileReader() throws IOException {
        try {
            return ((ReversedLinesFileReader.Builder)((ReversedLinesFileReader.Builder)((ReversedLinesFileReader.Builder)ReversedLinesFileReader.builder().setPath(this.log.getPath())).setCharset(StandardCharsets.UTF_8)).setBufferSize(0x100000)).get();
        }
        catch (NoSuchMethodError e) {
            return new ReversedLinesFileReader(this.log.getFile(), 0x100000, StandardCharsets.UTF_8);
        }
    }

    public String getFirstLinesString() {
        return String.join((CharSequence)"\n", this.firstLines);
    }

    public String getLastLinesString() {
        return this.lastLines == null ? null : String.join((CharSequence)"\n", this.lastLines);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String getAllLinesString() {
        LogReader logReader = this;
        synchronized (logReader) {
            if (this.allLinesStringCached == null) {
                this.allLinesStringCached = String.join((CharSequence)"\n", this.getAllLinesList());
            }
            return this.allLinesStringCached;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized List<String> getAllLinesList() {
        LogReader logReader = this;
        synchronized (logReader) {
            if (this.allLinesListCached == null) {
                this.allLinesListCached = new ArrayList<String>();
                this.allLinesListCached.addAll(this.firstLines);
                if (this.lastLines != null) {
                    this.allLinesListCached.addAll(this.lastLines);
                }
            }
            return this.allLinesListCached;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void destroyAllLinesCache() {
        LogReader logReader = this;
        synchronized (logReader) {
            this.allLinesStringCached = null;
            this.allLinesListCached = null;
        }
    }

    public synchronized List<String> getLastNLines(int n) {
        List<String> allLines = this.getAllLinesList();
        if (allLines.isEmpty()) {
            return new ArrayList<String>();
        }
        int startIndex = Math.max(0, allLines.size() - n);
        return new ArrayList<String>(allLines.subList(startIndex, allLines.size()));
    }

    public synchronized String getLastLine() {
        List<String> lastLine = this.getLastNLines(1);
        return !lastLine.isEmpty() ? lastLine.get(0) : "";
    }

    public int getCountedLines() {
        return this.countedLines;
    }

    public boolean isLineCountInterrupted() {
        return this.lineCountInterrupted;
    }
}

