/*
 * Decompiled with CFR 0.152.
 */
package dev.kostromdan.mods.crash_assistant.app.logs_analyser.crash_reasons.advanced;

import dev.kostromdan.mods.crash_assistant.app.CrashAssistantApp;
import dev.kostromdan.mods.crash_assistant.app.logs_analyser.KnownCrashReason;
import dev.kostromdan.mods.crash_assistant.app.logs_analyser.Log;
import dev.kostromdan.mods.crash_assistant.app.logs_analyser.LogType;
import dev.kostromdan.mods.crash_assistant.app.logs_analyser.LogsList;
import dev.kostromdan.mods.crash_assistant.app.utils.ModuleFinder;
import dev.kostromdan.mods.crash_assistant.common_config.lang.LanguageProvider;
import dev.kostromdan.mods.crash_assistant.common_config.mod_list.Mod;
import dev.kostromdan.mods.crash_assistant.common_config.mod_list.ModListDiff;
import dev.kostromdan.mods.crash_assistant.common_config.mod_list.ModListUtils;
import dev.kostromdan.mods.crash_assistant.common_config.platform.PlatformHelp;
import java.lang.invoke.CallSite;
import java.util.AbstractMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MixinApply
extends KnownCrashReason {
    private static final Pattern JSON_CONFIG_PATTERN = Pattern.compile("\\b(?![\\w.\\-]*refmap)[\\w.\\-]+\\.json\\b");

    public MixinApply() {
        super(LogType.LOG, LanguageProvider.get((String)"warnings.mixin_apply_common_start"), new String[0]);
    }

    @Override
    public boolean matches(Log latestLog) {
        String startWarn = "";
        if (!PlatformHelp.isLinkDefault()) {
            if (ModListDiff.isModpackCreator()) {
                startWarn = "<strong>You are seeing this analysis only because you are creator of this modpack. Won't be displayed to the end users.</strong>\n\n";
            } else {
                CrashAssistantApp.LOGGER.warn("Skipping MixinApply analysis due to it's in beta and game ran by the end user of this modpack.");
                return false;
            }
        }
        ArrayList<Log> logs = new ArrayList<Log>();
        for (Log log : LogsList.getLogs()) {
            if (log.getType() != LogType.LAUNCHER_LOG) continue;
            logs.add(log);
        }
        for (Log log : LogsList.getLogs()) {
            if (log.getType() != LogType.CRASH_REPORT) continue;
            logs.add(log);
        }
        logs.add(latestLog);
        HashMap<String, String> configToJarMap = MixinApply.getMixinConfigToJarMapping(ModListUtils.getCurrentModList((boolean)true));
        for (Log log : logs) {
            MixinParsingResult result = MixinApply.parseLatestMixinError(log, configToJarMap);
            if (result == null) continue;
            String mixinConfig = result.getMixinConfig();
            String jarName = configToJarMap.get(mixinConfig);
            String conflictingJarName = null;
            String conflictingMixin = null;
            if (result.getRequiredJavaVersion() != null) {
                this.message = this.message + LanguageProvider.get((String)"warnings.mixin_apply_java_version");
                this.message = this.message.replace("$REQUIRED_JAVA_VERSION$", "<strong style='color: red;'>" + result.getRequiredJavaVersion() + "</strong>");
                this.message = this.message.replace("$CURRENT_JAVA_VERSION$", "<strong style='color: red;'>JAVA_" + MixinApply.getMajorJavaVersion() + "</strong>");
            } else {
                if (result.getConflictingJarName() != null) {
                    conflictingJarName = result.getConflictingJarName();
                    this.message = this.message + LanguageProvider.get((String)"warnings.mixin_apply_conflicting_with_jar");
                } else {
                    conflictingMixin = MixinApply.findConflictingMixin(result.getMixinConfig(), latestLog, configToJarMap);
                    if (conflictingMixin != null) {
                        conflictingJarName = configToJarMap.get(conflictingMixin);
                        this.message = this.message + LanguageProvider.get((String)"warnings.mixin_apply_conflicting");
                    } else {
                        this.message = this.message + LanguageProvider.get((String)"warnings.mixin_apply");
                    }
                }
                this.message = this.message + LanguageProvider.get((String)"warnings.mixin_apply_common_end");
            }
            this.message = this.message.replace("$MOD$", "<strong style='color: red;'>" + jarName + "</strong>");
            this.message = this.message.replace("$CONFIG$", "<strong>" + mixinConfig + "</strong>");
            if (conflictingMixin != null) {
                this.message = this.message.replace("$CONFIG_2$", "<strong>" + conflictingMixin + "</strong>");
            }
            if (conflictingJarName != null) {
                this.message = this.message.replace("$MOD_2$", "<strong style='color: red;'>" + conflictingJarName + "</strong>");
            }
            this.message = startWarn + this.message;
            return true;
        }
        return false;
    }

    private static MixinParsingResult parseLatestMixinError(Log log, HashMap<String, String> configToJarMap) {
        List<String> lines = log.getType() == LogType.CRASH_REPORT ? log.getReader().getAllLinesList() : log.getReader().getLastNLines(300);
        block0: for (int i = lines.size() - 1; i >= 0; --i) {
            String[] patterns;
            HashSet<String> configs;
            String line = lines.get(i);
            if (!line.contains("org.spongepowered.asm.")) continue;
            if (!line.contains("Caused by:") && line.contains("org.spongepowered.asm.launch.MixinInitialisationError: Error initialising mixin config ")) {
                String nextLine;
                configs = MixinApply.extractFromLineMixinConfigs(line, configToJarMap);
                if (configs.size() != 1) continue;
                String config = configs.iterator().next();
                for (int j = i + 1; j < lines.size() && ((nextLine = lines.get(j)).contains("Caused by: ") || nextLine.contains("at ")); ++j) {
                    if (!nextLine.contains("Caused by: ")) continue;
                    if (!nextLine.contains("java.lang.IllegalArgumentException: The requested compatibility level ") || !nextLine.contains(" could not be set. Level is not supported by the active JRE or ASM version ")) continue block0;
                    String requiredJava = nextLine.split("Caused by: java\\.lang\\.IllegalArgumentException: The requested compatibility level ")[1].split(" ")[0];
                    MixinParsingResult result = new MixinParsingResult(config, null);
                    result.setRequiredJavaVersion(requiredJava);
                    return result;
                }
                continue;
            }
            if (!line.contains("Caused by: org.spongepowered.asm.mixin.") || (configs = MixinApply.extractFromLineMixinConfigs(line, configToJarMap)).size() != 1) continue;
            for (String pattern : patterns = new String[]{" merged by ", " was not located in the target class ", " previously written by "}) {
                List<String> jarsContainingModule;
                String packageName;
                if (!line.contains(pattern) || MixinApply.isInternalClass(packageName = line.split(pattern)[1].split(" ")[0]) || (jarsContainingModule = ModuleFinder.findJarsInFolderAsync(Collections.singletonList(packageName), ModListUtils.getCurrentModList((boolean)true))).isEmpty()) continue;
                return new MixinParsingResult(configs.iterator().next(), jarsContainingModule.get(0));
            }
            return new MixinParsingResult(configs.iterator().next(), null);
        }
        return null;
    }

    private static String findConflictingMixin(String mixinConfig, Log log, HashMap<String, String> configToJarMap) {
        List<String> lines = log.getReader().getLastNLines(1000);
        for (int i = lines.size() - 1; i >= 0; --i) {
            HashSet<String> configs;
            String line = lines.get(i);
            if (!line.contains(mixinConfig) || (configs = MixinApply.extractFromLineMixinConfigs(line, configToJarMap)).size() != 2 || !line.contains(" conflict. Skipping ")) continue;
            configs.remove(mixinConfig);
            return configs.iterator().next();
        }
        return null;
    }

    public static HashSet<String> extractFromLineMixinConfigs(String line, HashMap<String, String> configToJarMap) {
        HashSet<String> configs = new HashSet<String>();
        Matcher m = JSON_CONFIG_PATTERN.matcher(line);
        while (m.find()) {
            String cfg = m.group();
            if (!configToJarMap.containsKey(cfg)) continue;
            configs.add(cfg);
        }
        return configs;
    }

    public static boolean isInternalClass(String className) {
        return (className = ModuleFinder.normalizeModuleName(className)).startsWith("net/minecraft/");
    }

    public static HashMap<String, String> getMixinConfigToJarMapping(LinkedHashSet<Mod> mods) {
        HashMap<String, String> result = new HashMap<String, String>();
        ArrayDeque<AbstractMap.SimpleEntry<Mod, Object>> stack = new ArrayDeque<AbstractMap.SimpleEntry<Mod, Object>>();
        for (Mod root : mods) {
            stack.push(new AbstractMap.SimpleEntry<Mod, String>(root, root.getJarName()));
        }
        while (!stack.isEmpty()) {
            Map.Entry entry = (Map.Entry)stack.pop();
            Mod mod = (Mod)entry.getKey();
            String jarPath = (String)entry.getValue();
            for (String cfg : mod.getMixinConfigs()) {
                result.putIfAbsent(cfg, jarPath);
            }
            for (Mod nested : mod.getJarJarMods()) {
                String fullNested = jarPath + "!" + nested.getPathFromJarJar() + nested.getJarName();
                stack.push(new AbstractMap.SimpleEntry<Mod, CallSite>(nested, (CallSite)((Object)fullNested)));
            }
        }
        return result;
    }

    public static int getMajorJavaVersion() {
        String spec = System.getProperty("java.specification.version");
        String[] parts = spec.split("\\.");
        int major = parts[0].equals("1") ? Integer.parseInt(parts[1]) : Integer.parseInt(parts[0]);
        return major;
    }

    public static class MixinParsingResult {
        private final String mixinConfig;
        private final String conflictingJarName;
        private String requiredJavaVersion = null;

        public MixinParsingResult(String mixinConfig, String conflictingJarName) {
            this.mixinConfig = mixinConfig;
            this.conflictingJarName = conflictingJarName;
        }

        public String getMixinConfig() {
            return this.mixinConfig;
        }

        public String getConflictingJarName() {
            return this.conflictingJarName;
        }

        public String getRequiredJavaVersion() {
            return this.requiredJavaVersion;
        }

        public void setRequiredJavaVersion(String requiredJavaVersion) {
            this.requiredJavaVersion = requiredJavaVersion;
        }
    }
}

