/*
 * Decompiled with CFR 0.152.
 */
package dev.kostromdan.mods.crash_assistant.app.logs_analyser.crash_reasons.win_event;

import dev.kostromdan.mods.crash_assistant.app.logs_analyser.KnownCrashReason;
import dev.kostromdan.mods.crash_assistant.app.logs_analyser.Log;
import dev.kostromdan.mods.crash_assistant.app.logs_analyser.LogType;
import dev.kostromdan.mods.crash_assistant.app.logs_analyser.RegexChecker;
import dev.kostromdan.mods.crash_assistant.common_config.lang.LanguageProvider;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class WasClosedByWindows
extends KnownCrashReason {
    public static final List<String> wasClosedMessagesRegex = Stream.of("The program java\\w*(?:\\.\\w+)? version \\S+ stopped interacting with Windowsand was closed\\.", "\u041f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u0430 java\\w*(?:\\.\\w+)? \u0432\u0435\u0440\u0441\u0438\u0438 \\S+ \u043f\u0435\u0440\u0435\u0441\u0442\u0430\u043b\u0430 \u0432\u0437\u0430\u0438\u043c\u043e\u0434\u0435\u0439\u0441\u0442\u0432\u043e\u0432\u0430\u0442\u044c \u0441 Windows \u0438 \u0431\u044b\u043b\u0430 \u0437\u0430\u043a\u0440\u044b\u0442\u0430\\.", "Le programme java\\w*(?:\\.\\w+)? version \\S+ a cess\u00e9 d'interagir avec Windows eta \u00e9t\u00e9 ferm\u00e9\\.", "Das Programm java\\w*(?:\\.\\w+)? Version \\S+ hat die Interaktion mit Windows beendet und wurde geschlossen\\.", "Das Programm java\\w*(?:\\.\\w+)? Version \\S+ hat aufgeh\u00f6rt mit Windows zu interagieren und wurde geschlossen\\.", "El programa java\\w*(?:\\.\\w+)? versi\u00f3n \\S+ dej\u00f3 de interactuar con Windowsy se cerr\u00f3\\.", "Programmet java\\w*(?:\\.\\w+)?, version \\S+ avslutades eftersom det slutade samverka med Windows\\.", "Programma java\\w*(?:\\.\\w+)? versie \\S+ communiceert niet meer met Windows en is gesloten\\.", "\ud504\ub85c\uadf8\ub7a8 java\\w*(?:\\.\\w+)? \ubc84\uc804 \\S+\uc774\\(\uac00\\) Windows\uc640\uc758 \uc0c1\ud638 \uc791\uc6a9\uc744 \uc911\uc9c0\ud558\uace0 \ub2eb\ud614\uc2b5\ub2c8\ub2e4\\.", "Verze \\S+ programu java\\w*(?:\\.\\w+)? ukon\u010dila interakci se syst\u00e9mem Windows a byla ukon\u010dena\\.", "O programa java\\w*(?:\\.\\w+)? vers\u00e3o \\S+ interagiu com o Windows e foi fechado\\.", "O programa java\\w*(?:\\.\\w+)? vers\u00e3o \\S+ parou de interagir com o Windows e foi fechado\\.", "Il programma java\\w*(?:\\.\\w+)? versione \\S+ interrotto l'interazione con Windows ed \u00e8 stato chiuso\\.", "Program java\\w*(?:\\.\\w+)? w wersji \\S+ przesta\u0142 wsp\u00f3\u0142pracowa\u0107 z systemem Windows i zosta\u0142 zamkni\u0119ty\\.", "Program java\\w*(?:\\.\\w+)? w wersji \\S+ przesta\u0142 korzysta\u0107 z systemu Windows i zosta\u0142 zamkni\u0119ty\\.").map(WasClosedByWindows::removeSpacesAndEndLines).collect(Collectors.toList());

    public static String removeSpacesAndEndLines(String s) {
        return s.replaceAll("[ ]|\\s*\\n\\s*", "");
    }

    public WasClosedByWindows() {
        super(LogType.WIN_EVENT, LanguageProvider.get((String)"warnings.closed_by_windows"), wasClosedMessagesRegex);
    }

    @Override
    public boolean matches(Log log) {
        log.getReader().readLogFileSafe();
        return RegexChecker.logContainsOneOfPatterns(WasClosedByWindows.removeSpacesAndEndLines(log.getReader().getAllLinesString()), log.getPath(), this.patterns);
    }
}

