/*
 * Decompiled with CFR 0.152.
 */
package dev.kostromdan.mods.crash_assistant.app.utils;

import dev.kostromdan.mods.crash_assistant.app.CrashAssistantApp;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public interface IntelCorruptedProcessorChecker {
    public static final Set<String> AFFECTED_MODELS = new HashSet<String>(Arrays.asList("i5-13600k", "i5-13600kf", "i5-14600k", "i5-14600kf", "i7-13700", "i7-13700f", "i7-13700k", "i7-13700kf", "i7-13790f", "i7-14700", "i7-14700f", "i7-14700k", "i7-14700kf", "i7-14790f", "i9-13900", "i9-13900f", "i9-13900k", "i9-13900kf", "i9-13900ks", "i9-14900", "i9-14900f", "i9-14900k", "i9-14900kf", "i9-14900ks", "i9-14900hx"));

    public static boolean isAffectedProcessor() {
        try {
            String model = IntelCorruptedProcessorChecker.extractModel();
            return model != null && AFFECTED_MODELS.contains(model);
        }
        catch (Exception e) {
            CrashAssistantApp.LOGGER.error("Error while checking processor", (Throwable)e);
            return false;
        }
    }

    public static String extractModel() {
        if (CrashAssistantApp.processor == null) {
            return null;
        }
        Matcher matcher = Pattern.compile("i[579]-\\d+[a-z]*", 2).matcher(CrashAssistantApp.processor);
        return matcher.find() ? matcher.group().toLowerCase() : null;
    }
}

