/*
 * Decompiled with CFR 0.152.
 */
package dev.kostromdan.mods.crash_assistant.app.utils;

import dev.kostromdan.mods.crash_assistant.common_config.utils.ProcessHelper;
import java.io.File;
import java.util.concurrent.TimeUnit;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class ModRemover {
    public static void main(String[] args) {
        if (args.length < 2) {
            ModRemover.showErrorAndExit("Insufficient arguments. Usage: ModRemover <modPath> <parentPID>");
            return;
        }
        String modPath = args[0];
        long parentPID = 0L;
        try {
            parentPID = Long.parseLong(args[1]);
        }
        catch (NumberFormatException e) {
            ModRemover.showErrorAndExit("Invalid PID format: " + args[1]);
            return;
        }
        boolean parentExited = ModRemover.waitForProcessToExit(parentPID);
        if (!parentExited) {
            ModRemover.showErrorAndExit("Parent process did not exit within the timeout period");
            return;
        }
        File modFile = new File(modPath);
        boolean success = false;
        String errorMessage = "";
        for (int i = 0; i < 5; ++i) {
            if (modFile.exists()) {
                try {
                    success = modFile.delete();
                    if (success) break;
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException ie) {
                        Thread.currentThread().interrupt();
                    }
                }
                catch (Exception e) {
                    errorMessage = e.getMessage();
                }
                continue;
            }
            ModRemover.showMissingFileMessage(modPath);
            return;
        }
        if (success) {
            ModRemover.showSuccessMessage(modPath);
        } else {
            ModRemover.showFailureMessage(modPath, errorMessage);
        }
    }

    private static boolean waitForProcessToExit(long pid) {
        if (!ProcessHelper.isProcessAlive((long)pid)) {
            return true;
        }
        for (int i = 0; i < 30; ++i) {
            if (!ProcessHelper.isProcessAlive((long)pid)) {
                return true;
            }
            try {
                TimeUnit.MILLISECONDS.sleep(500L);
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return false;
            }
        }
        return false;
    }

    private static void showSuccessMessage(String modPath) {
        SwingUtilities.invokeLater(() -> {
            ModRemover.setupLookAndFeel();
            String message = "Crash Assistant has been successfully removed from:\n" + modPath + "\n\nPlease restart your game.";
            JDialog dialog = new JOptionPane(message, 1, -1).createDialog("Crash Assistant Removed");
            dialog.setAlwaysOnTop(true);
            dialog.setVisible(true);
            System.exit(0);
        });
    }

    private static void showFailureMessage(String modPath, String errorMessage) {
        SwingUtilities.invokeLater(() -> {
            ModRemover.setupLookAndFeel();
            String message = "Failed to remove Crash Assistant from:\n" + modPath + "\n\nPlease delete it manually from your mods folder." + (String)(errorMessage.isEmpty() ? "" : "\n\nError: " + errorMessage);
            JDialog dialog = new JOptionPane(message, 2, -1).createDialog("Removal Failed");
            dialog.setAlwaysOnTop(true);
            dialog.setVisible(true);
            System.exit(1);
        });
    }

    private static void showMissingFileMessage(String modPath) {
        SwingUtilities.invokeLater(() -> {
            ModRemover.setupLookAndFeel();
            String message = "Could not find Crash Assistant mod file at:\n" + modPath + "\n\nIt may have been moved, renamed, or already removed.";
            JDialog dialog = new JOptionPane(message, 2, -1).createDialog("File Not Found");
            dialog.setAlwaysOnTop(true);
            dialog.setVisible(true);
            System.exit(1);
        });
    }

    private static void showErrorAndExit(String errorMessage) {
        SwingUtilities.invokeLater(() -> {
            ModRemover.setupLookAndFeel();
            JDialog dialog = new JOptionPane("Error in Crash Assistant remover:\n" + errorMessage + "\n\nPlease delete it manually from your mods folder.", 0, -1).createDialog("Error");
            dialog.setAlwaysOnTop(true);
            dialog.setVisible(true);
            System.exit(1);
        });
    }

    private static void setupLookAndFeel() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

