/*
 * Decompiled with CFR 0.152.
 */
package dev.kostromdan.mods.crash_assistant.app.utils;

import dev.kostromdan.mods.crash_assistant.common_config.loading_utils.JarInJarHelper;
import dev.kostromdan.mods.crash_assistant.common_config.mod_list.Mod;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.stream.Collectors;

public class ModuleFinder {
    public static List<String> findJarsContainingEntries(List<String> packagePrefixes, Path jarPath) {
        List<String> pathPrefixes = packagePrefixes.stream().map(ModuleFinder::normalizeModuleName).collect(Collectors.toList());
        ArrayList<String> results = new ArrayList<String>();
        String topName = jarPath.getFileName().toString();
        try (JarFile jarFile = new JarFile(jarPath.toFile());){
            boolean matchedTop = false;
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                String name = entry.getName();
                if (!matchedTop) {
                    for (String prefix : pathPrefixes) {
                        if (!ModuleFinder.normalizeModuleName(name).startsWith(prefix)) continue;
                        results.add(topName);
                        matchedTop = true;
                        break;
                    }
                }
                if (name.equals("module-info.class")) {
                    JarInJarHelper.LOGGER.warn("Found module-info.class in " + topName);
                }
                if (entry.isDirectory() || !name.endsWith(".jar")) continue;
                ModuleFinder.processNestedJar(name, () -> ModuleFinder.readAllBytes(jarFile.getInputStream(entry)), pathPrefixes, topName + "!/" + name, results);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return results;
    }

    public static List<String> findJarsInFolderAsync(List<String> packagePrefixes, LinkedHashSet<Mod> mods) {
        Path modsFolderPath = Paths.get("mods", new String[0]);
        ExecutorService executor = Executors.newWorkStealingPool();
        HashMap jarMap = new HashMap();
        try {
            Files.walk(modsFolderPath, new FileVisitOption[0]).filter(path -> path.toString().endsWith(".jar")).forEach(jarPath -> jarMap.put(jarPath.getFileName().toString(), jarPath));
        }
        catch (IOException e) {
            executor.shutdown();
            return new ArrayList<String>();
        }
        ArrayList<CompletableFuture> tasks = new ArrayList<CompletableFuture>();
        for (Mod mod : mods) {
            CompletableFuture task = CompletableFuture.supplyAsync(() -> {
                Path jarPath = (Path)jarMap.get(mod.getJarName());
                if (jarPath != null) {
                    return ModuleFinder.findJarsContainingEntries(packagePrefixes, jarPath);
                }
                return new ArrayList();
            }, executor);
            tasks.add(task);
        }
        ArrayList<String> allResults = new ArrayList<String>();
        for (CompletableFuture task : tasks) {
            try {
                allResults.addAll((Collection)task.get());
            }
            catch (Exception exception) {}
        }
        executor.shutdown();
        return allResults;
    }

    private static void processNestedJar(String entryName, ByteSupplier supplier, List<String> pathPrefixes, String containerName, List<String> results) {
        try {
            byte[] data = supplier.get();
            try (JarInputStream jis = new JarInputStream(new ByteArrayInputStream(data));){
                JarEntry ne;
                boolean matched = false;
                while ((ne = jis.getNextJarEntry()) != null) {
                    String n = ne.getName();
                    if (n.equals("module-info.class")) {
                        JarInJarHelper.LOGGER.warn("Found module-info.class in " + containerName);
                    }
                    if (!matched) {
                        for (String prefix : pathPrefixes) {
                            if (!ModuleFinder.normalizeModuleName(n).startsWith(prefix)) continue;
                            results.add(containerName);
                            matched = true;
                            break;
                        }
                    }
                    if (ne.isDirectory() || !n.endsWith(".jar")) continue;
                    ModuleFinder.processNestedJar(n, () -> ModuleFinder.readAllBytes(jis), pathPrefixes, containerName + "!/" + n, results);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static byte[] readAllBytes(InputStream in) throws IOException {
        int r;
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        byte[] tmp = new byte[4096];
        while ((r = in.read(tmp)) != -1) {
            buf.write(tmp, 0, r);
        }
        return buf.toByteArray();
    }

    public static String normalizeModuleName(String moduleName) {
        if (!((String)(moduleName = ((String)moduleName).toLowerCase().replace('.', '/'))).endsWith("/")) {
            moduleName = (String)moduleName + "/";
        }
        return moduleName;
    }

    @FunctionalInterface
    private static interface ByteSupplier {
        public byte[] get() throws Exception;
    }
}

