/*
 * Decompiled with CFR 0.152.
 */
package dev.kostromdan.mods.crash_assistant.app.utils.gpu;

import dev.kostromdan.mods.crash_assistant.app.utils.gpu.GPU;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;

public class DirectXGPUDetector {
    private static native byte[] getNativeSerialisedGPUs();

    public static String getSerialisedGPUs() {
        byte[] bytes = DirectXGPUDetector.getNativeSerialisedGPUs();
        return new String(bytes, StandardCharsets.UTF_8);
    }

    private static void loadNativeLibraryFromJar() throws IOException {
        String libraryName = "gpu-detect-jni.dll";
        Path tempDir = Files.createTempDirectory("gpu-detect-jni", new FileAttribute[0]);
        tempDir.toFile().deleteOnExit();
        Path tempFile = tempDir.resolve(libraryName);
        try (InputStream in = DirectXGPUDetector.class.getClassLoader().getResourceAsStream(libraryName);){
            if (in == null) {
                throw new IOException("Could not find " + libraryName + " in the JAR");
            }
            Files.copy(in, tempFile, StandardCopyOption.REPLACE_EXISTING);
        }
        System.load(tempFile.toAbsolutePath().toString());
    }

    public static void main(String[] args) throws Exception {
        String serialized = DirectXGPUDetector.getSerialisedGPUs();
        System.out.println(serialized);
        List<GPU> gpus = GPU.deserializeGPUs(serialized);
        System.out.println(gpus);
    }

    static {
        try {
            DirectXGPUDetector.loadNativeLibraryFromJar();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load native library: " + e.getMessage(), e);
        }
    }
}

