/*
 * Decompiled with CFR 0.152.
 */
package dev.kostromdan.mods.crash_assistant.app.utils.gpu;

import dev.kostromdan.mods.crash_assistant.app.utils.gpu.GPU;
import dev.kostromdan.mods.crash_assistant.app.utils.gpu.RendererType;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.List;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.vulkan.VK10;
import org.lwjgl.vulkan.VkApplicationInfo;
import org.lwjgl.vulkan.VkInstance;
import org.lwjgl.vulkan.VkInstanceCreateInfo;
import org.lwjgl.vulkan.VkPhysicalDevice;
import org.lwjgl.vulkan.VkPhysicalDeviceProperties;

public class VulkanGPUDetector {
    public static List<GPU> detectGPUs() {
        VkInstance instance = VulkanGPUDetector.createVulkanInstance();
        ArrayList<GPU> gpus = new ArrayList<GPU>();
        try (MemoryStack stack = MemoryStack.stackPush();){
            IntBuffer deviceCount = stack.mallocInt(1);
            int err = VK10.vkEnumeratePhysicalDevices((VkInstance)instance, (IntBuffer)deviceCount, null);
            if (err != 0) {
                throw new RuntimeException("Failed to enumerate physical devices: " + err);
            }
            if (deviceCount.get(0) == 0) {
                VK10.vkDestroyInstance((VkInstance)instance, null);
                ArrayList<GPU> arrayList = gpus;
                return arrayList;
            }
            PointerBuffer devices = stack.mallocPointer(deviceCount.get(0));
            VK10.vkEnumeratePhysicalDevices((VkInstance)instance, (IntBuffer)deviceCount, (PointerBuffer)devices);
            for (int i = 0; i < devices.capacity(); ++i) {
                VkPhysicalDevice device = new VkPhysicalDevice(devices.get(i), instance);
                VkPhysicalDeviceProperties properties = VkPhysicalDeviceProperties.callocStack((MemoryStack)stack);
                VK10.vkGetPhysicalDeviceProperties((VkPhysicalDevice)device, (VkPhysicalDeviceProperties)properties);
                String deviceName = properties.deviceNameString();
                int deviceType = properties.deviceType();
                RendererType type = deviceType == 1 ? RendererType.INTEGRATED : (deviceType == 2 ? RendererType.DEDICATED : (deviceType == 3 ? RendererType.VIRTUAL_GPU : RendererType.UNKNOWN));
                gpus.add(new GPU(type, deviceName));
            }
        }
        VK10.vkDestroyInstance((VkInstance)instance, null);
        return gpus;
    }

    private static VkInstance createVulkanInstance() {
        try (MemoryStack stack = MemoryStack.stackPush();){
            VkApplicationInfo appInfo = VkApplicationInfo.callocStack((MemoryStack)stack).sType(0).pApplicationName(stack.UTF8((CharSequence)"GPU Detector")).applicationVersion(VK10.VK_MAKE_VERSION((int)1, (int)0, (int)0)).pEngineName(stack.UTF8((CharSequence)"No Engine")).engineVersion(VK10.VK_MAKE_VERSION((int)1, (int)0, (int)0)).apiVersion(VK10.VK_API_VERSION_1_0);
            VkInstanceCreateInfo createInfo = VkInstanceCreateInfo.callocStack((MemoryStack)stack).sType(1).pApplicationInfo(appInfo);
            PointerBuffer instancePtr = stack.mallocPointer(1);
            if (VK10.vkCreateInstance((VkInstanceCreateInfo)createInfo, null, (PointerBuffer)instancePtr) != 0) {
                throw new RuntimeException("Failed to create Vulkan instance");
            }
            VkInstance vkInstance = new VkInstance(instancePtr.get(0), createInfo);
            return vkInstance;
        }
    }

    public static String getSerialisedGPUs() {
        List<GPU> gpus = VulkanGPUDetector.detectGPUs();
        return GPU.serializeGPUs(gpus);
    }

    public static void main(String[] args) {
        String serialized = VulkanGPUDetector.getSerialisedGPUs();
        System.out.println(serialized);
        List<GPU> gpus = GPU.deserializeGPUs(serialized);
        System.out.println(gpus);
    }
}

