/*
 * Decompiled with CFR 0.152.
 */
package com.github.L_Ender.cataclysm.entity.projectile;

import com.github.L_Ender.cataclysm.config.CMConfig;
import com.github.L_Ender.cataclysm.entity.AnimationMonster.BossMonsters.Ignis_Entity;
import com.github.L_Ender.cataclysm.entity.effect.Cm_Falling_Block_Entity;
import com.github.L_Ender.cataclysm.entity.projectile.Ignis_Abyss_Fireball_Entity;
import com.github.L_Ender.cataclysm.init.ModEffect;
import com.github.L_Ender.cataclysm.init.ModEntities;
import com.github.L_Ender.cataclysm.util.CustomExplosion.IgnisExplosion;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class Ignis_Fireball_Entity
extends AbstractHurtingProjectile {
    private static final EntityDataAccessor<Boolean> SOUL = SynchedEntityData.m_135353_(Ignis_Fireball_Entity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> FIRED = SynchedEntityData.m_135353_(Ignis_Fireball_Entity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int timer;
    private Vec3[] trailPositions = new Vec3[64];
    private int trailPointer = -1;

    public Ignis_Fireball_Entity(EntityType<? extends Ignis_Fireball_Entity> type, Level level) {
        super(type, level);
    }

    public Ignis_Fireball_Entity(Level level, LivingEntity entity, double x, double y, double z) {
        super((EntityType)ModEntities.IGNIS_FIREBALL.get(), entity, x, y, z, level);
    }

    public Ignis_Fireball_Entity(Level worldIn, LivingEntity entity) {
        this((EntityType<? extends Ignis_Fireball_Entity>)((EntityType)ModEntities.IGNIS_FIREBALL.get()), worldIn);
        this.m_5602_((Entity)entity);
    }

    public boolean m_6060_() {
        return false;
    }

    public void m_8119_() {
        Entity entity;
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            --this.timer;
            if (this.timer <= 0 && !this.getFired()) {
                this.setFired(true);
            }
        }
        if (this.timer < -160) {
            this.m_146870_();
        }
        if ((this.timer == 0 || this.timer == -40) && (entity = this.m_19749_()) instanceof Mob && ((Mob)entity).m_5448_() != null) {
            LivingEntity target = ((Mob)entity).m_5448_();
            if (target == null) {
                this.m_146870_();
            }
            float speed = this.isSoul() ? 0.25f : 0.2f;
            double dx = target.m_20185_() - this.m_20185_();
            double dy = target.m_20186_() + (double)(target.m_20206_() * 0.5f) - this.m_20186_();
            double dz = target.m_20189_() - this.m_20189_();
            double d = Math.sqrt(dx * dx + dy * dy + dz * dz);
            this.f_36813_ = (dx /= d) * (double)speed;
            this.f_36814_ = (dy /= d) * (double)speed;
            this.f_36815_ = (dz /= d) * (double)speed;
        }
        Vec3 trailAt = this.m_20182_().m_82520_(0.0, (double)(this.m_20206_() / 2.0f), 0.0);
        if (this.trailPointer == -1) {
            Vec3 backAt = trailAt;
            for (int i = 0; i < this.trailPositions.length; ++i) {
                this.trailPositions[i] = backAt;
            }
        }
        if (++this.trailPointer == this.trailPositions.length) {
            this.trailPointer = 0;
        }
        this.trailPositions[this.trailPointer] = trailAt;
    }

    public void setUp(int delay) {
        this.setFired(false);
        this.timer = delay;
    }

    protected void m_5790_(EntityHitResult result) {
        super.m_5790_(result);
        Entity shooter = this.m_19749_();
        if (!(this.m_9236_().f_46443_ || !this.getFired() || result.m_82443_() instanceof Ignis_Fireball_Entity || result.m_82443_() instanceof Ignis_Abyss_Fireball_Entity || result.m_82443_() instanceof Cm_Falling_Block_Entity || result.m_82443_() instanceof Ignis_Entity && shooter instanceof Ignis_Entity)) {
            boolean flag;
            Entity entity = result.m_82443_();
            if (shooter instanceof LivingEntity) {
                LivingEntity owner = (LivingEntity)shooter;
                float damage = this.isSoul() ? 8.0f : 6.0f;
                flag = entity instanceof LivingEntity ? entity.m_6469_(this.m_269291_().m_269299_((Entity)this, owner), damage + ((LivingEntity)entity).m_21233_() * 0.07f) : entity.m_6469_(this.m_269291_().m_269299_((Entity)this, owner), damage);
                if (flag) {
                    this.m_19970_(owner, entity);
                    if (owner instanceof Ignis_Entity) {
                        owner.m_5634_(5.0f * (float)CMConfig.IgnisHealingMultiplier);
                    } else {
                        owner.m_5634_(5.0f);
                    }
                }
            } else {
                flag = entity.m_6469_(this.m_269291_().m_269425_(), 6.0f);
            }
            IgnisExplosion explosion = new IgnisExplosion(this.m_9236_(), (Entity)this, null, null, this.m_20185_(), this.m_20186_(), this.m_20189_(), 1.0f, true, Explosion.BlockInteraction.KEEP);
            explosion.m_46061_();
            explosion.finalizeExplosion(this.isSoul() ? 2 : 1, 0.35);
            this.m_146870_();
            if (flag && entity instanceof LivingEntity) {
                MobEffectInstance effectinstance1 = ((LivingEntity)entity).m_21124_((MobEffect)ModEffect.EFFECTBLAZING_BRAND.get());
                int i = 1;
                if (effectinstance1 != null) {
                    i += effectinstance1.m_19564_();
                    ((LivingEntity)entity).m_6234_((MobEffect)ModEffect.EFFECTBLAZING_BRAND.get());
                } else {
                    --i;
                }
                i = Mth.m_14045_((int)i, (int)0, (int)4);
                MobEffectInstance effectinstance = new MobEffectInstance((MobEffect)ModEffect.EFFECTBLAZING_BRAND.get(), 200, i, false, false, true);
                ((LivingEntity)entity).m_7292_(effectinstance);
            }
        }
    }

    protected void m_8060_(BlockHitResult result) {
        super.m_8060_(result);
        if (!this.m_9236_().f_46443_ && this.getFired()) {
            IgnisExplosion explosion = new IgnisExplosion(this.m_9236_(), (Entity)this, null, null, this.m_20185_(), this.m_20186_(), this.m_20189_(), 1.0f, true, Explosion.BlockInteraction.KEEP);
            explosion.m_46061_();
            explosion.finalizeExplosion(this.isSoul() ? 2 : 1, 0.35);
            this.m_146870_();
        }
    }

    public Vec3 getTrailPosition(int pointer, float partialTick) {
        if (this.m_213877_()) {
            partialTick = 1.0f;
        }
        int i = this.trailPointer - pointer & 0x3F;
        int j = this.trailPointer - pointer - 1 & 0x3F;
        Vec3 d0 = this.trailPositions[j];
        Vec3 d1 = this.trailPositions[i].m_82546_(d0);
        return d0.m_82549_(d1.m_82490_((double)partialTick));
    }

    public boolean hasTrail() {
        return this.trailPointer != -1;
    }

    protected void m_6532_(HitResult ray) {
        HitResult.Type raytraceresult$type = ray.m_6662_();
        if (raytraceresult$type == HitResult.Type.ENTITY) {
            this.m_5790_((EntityHitResult)ray);
        } else if (raytraceresult$type == HitResult.Type.BLOCK) {
            this.m_8060_((BlockHitResult)ray);
        }
    }

    public boolean m_6087_() {
        return false;
    }

    public boolean m_6469_(DamageSource p_37616_, float p_37617_) {
        return false;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(SOUL, (Object)false);
        this.f_19804_.m_135372_(FIRED, (Object)false);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("is_soul", this.isSoul());
        compound.m_128405_("timer", this.timer);
        compound.m_128379_("fired", this.getFired());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setSoul(compound.m_128471_("is_soul"));
        this.timer = compound.m_128451_("timer");
        this.setFired(compound.m_128471_("fired"));
    }

    public boolean isSoul() {
        return (Boolean)this.f_19804_.m_135370_(SOUL);
    }

    public void setSoul(boolean IsSoul) {
        this.f_19804_.m_135381_(SOUL, (Object)IsSoul);
    }

    public void setFired(boolean fired) {
        this.f_19804_.m_135381_(FIRED, (Object)fired);
    }

    public boolean getFired() {
        return (Boolean)this.f_19804_.m_135370_(FIRED);
    }
}

