/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.bookstate;

import com.klikli_dev.modonomicon.bookstate.BookUnlockStates;
import com.klikli_dev.modonomicon.bookstate.BookVisualStates;
import com.klikli_dev.modonomicon.util.Codecs;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.saveddata.SavedData;

public class BookStatesSaveData
extends SavedData {
    public static final Codec<BookStatesSaveData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codecs.concurrentMap(Codecs.UUID, BookUnlockStates.CODEC).fieldOf("unlockStates").forGetter(state -> state.unlockStates), (App)Codecs.concurrentMap(Codecs.UUID, BookVisualStates.CODEC).fieldOf("visualStates").forGetter(state -> state.visualStates)).apply((Applicative)instance, BookStatesSaveData::new));
    public static final String ID = "modonomicon_book_states";
    public ConcurrentMap<UUID, BookUnlockStates> unlockStates;
    public ConcurrentMap<UUID, BookVisualStates> visualStates;

    public BookStatesSaveData() {
        this(new ConcurrentHashMap<UUID, BookUnlockStates>(), new ConcurrentHashMap<UUID, BookVisualStates>());
    }

    public BookStatesSaveData(ConcurrentMap<UUID, BookUnlockStates> unlockStates, ConcurrentMap<UUID, BookVisualStates> visualStates) {
        this.unlockStates = unlockStates;
        this.visualStates = visualStates;
        this.m_77762_();
    }

    public static BookStatesSaveData load(CompoundTag pCompoundTag) {
        return (BookStatesSaveData)((Object)CODEC.parse((DynamicOps)NbtOps.f_128958_, (Object)pCompoundTag.m_128423_("bookStates")).result().orElseThrow());
    }

    public BookUnlockStates getUnlockStates(UUID playerUUID) {
        return this.unlockStates.computeIfAbsent(playerUUID, uuid -> {
            this.m_77762_();
            return new BookUnlockStates();
        });
    }

    public BookVisualStates getVisualStates(UUID playerUUID) {
        return this.visualStates.computeIfAbsent(playerUUID, uuid -> {
            this.m_77762_();
            return new BookVisualStates();
        });
    }

    public CompoundTag m_7176_(CompoundTag compoundTag) {
        compoundTag.m_128365_("bookStates", (Tag)CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)this).result().orElseThrow());
        return compoundTag;
    }
}

