/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.client.render.page;

import com.klikli_dev.modonomicon.book.page.BookImagePage;
import com.klikli_dev.modonomicon.client.gui.book.BookContentScreen;
import com.klikli_dev.modonomicon.client.gui.book.button.SmallArrowButton;
import com.klikli_dev.modonomicon.client.render.page.BookPageRenderer;
import com.klikli_dev.modonomicon.client.render.page.PageWithTextRenderer;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Style;
import org.jetbrains.annotations.Nullable;

public class BookImagePageRenderer
extends BookPageRenderer<BookImagePage>
implements PageWithTextRenderer {
    int index;

    public BookImagePageRenderer(BookImagePage page) {
        super(page);
    }

    public void handleButtonArrow(Button button) {
        boolean left = ((SmallArrowButton)button).left;
        this.index = left ? --this.index : ++this.index;
    }

    @Override
    public void onBeginDisplayPage(BookContentScreen parentScreen, int left, int top) {
        super.onBeginDisplayPage(parentScreen, left, top);
        int x = 94;
        int y = 101;
        this.addButton(new SmallArrowButton(parentScreen, x, y, true, () -> this.index > 0, this::handleButtonArrow));
        this.addButton(new SmallArrowButton(parentScreen, x + 10, y, false, () -> this.index < ((BookImagePage)this.page).getImages().length - 1, this::handleButtonArrow));
    }

    @Override
    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float ticks) {
        Style style;
        if (((BookImagePage)this.page).hasTitle()) {
            this.renderTitle(guiGraphics, ((BookImagePage)this.page).getTitle(), false, 62, 0);
        }
        this.renderBookTextHolder(guiGraphics, ((BookImagePage)this.getPage()).getText(), 0, this.getTextY(), 124);
        int x = 9;
        int y = 7;
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_85841_(0.5f, 0.5f, 1.0f);
        guiGraphics.m_280218_(((BookImagePage)this.page).getImages()[this.index], x * 2 + 6, y * 2 + 6, 0, 0, 200, 200);
        guiGraphics.m_280168_().m_85841_(2.0f, 2.0f, 1.0f);
        guiGraphics.m_280168_().m_85849_();
        if (((BookImagePage)this.page).hasBorder()) {
            BookContentScreen.drawFromTexture(guiGraphics, ((BookImagePage)this.getPage()).getBook(), x, y, 405, 149, 106, 106);
        }
        if (((BookImagePage)this.page).getImages().length > 1 && ((BookImagePage)this.page).hasBorder()) {
            int xs = x + 83;
            int ys = y + 92;
            guiGraphics.m_280509_(xs, ys, xs + 20, ys + 11, 0x44000000);
            guiGraphics.m_280509_(xs - 1, ys - 1, xs + 20, ys + 11, 0x44000000);
        }
        if ((style = this.getClickedComponentStyleAt(mouseX, mouseY)) != null) {
            this.parentScreen.renderComponentHoverEffect(guiGraphics, style, mouseX, mouseY);
        }
    }

    @Override
    @Nullable
    public Style getClickedComponentStyleAt(double pMouseX, double pMouseY) {
        if (pMouseX > 0.0 && pMouseY > 0.0) {
            Style titleStyle;
            if (((BookImagePage)this.page).hasTitle() && (titleStyle = this.getClickedComponentStyleAtForTitle(((BookImagePage)this.page).getTitle(), 62, 0, pMouseX, pMouseY)) != null) {
                return titleStyle;
            }
            Style textStyle = this.getClickedComponentStyleAtForTextHolder(((BookImagePage)this.page).getText(), 0, this.getTextY(), 124, pMouseX, pMouseY);
            if (textStyle != null) {
                return textStyle;
            }
        }
        return super.getClickedComponentStyleAt(pMouseX, pMouseY);
    }

    @Override
    public int getTextY() {
        return 115;
    }
}

