/*
 * Decompiled with CFR 0.152.
 */
package net.jacobwasbeast.picaxe.blocks.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.jacobwasbeast.picaxe.blocks.ImageBedBlock;
import net.jacobwasbeast.picaxe.blocks.entities.ImageBedBlockEntity;
import net.jacobwasbeast.picaxe.utils.ColorUtils;
import net.jacobwasbeast.picaxe.utils.ImageUtils;
import net.jacobwasbeast.picaxe.utils.RenderUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.Property;

public class ImageBedBlockRenderer
implements BlockEntityRenderer<ImageBedBlockEntity> {
    public void render(ImageBedBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        Minecraft minecraft = Minecraft.m_91087_();
        BlockState customState = blockEntity.m_58900_();
        if (blockEntity.m_58898_() && customState.m_61143_((Property)BedBlock.f_49440_) == BedPart.FOOT) {
            return;
        }
        Block vanillaBedBlock = ColorUtils.BEDS_BY_COLOR.get(blockEntity.getColor());
        Direction facing = (Direction)customState.m_61143_((Property)ImageBedBlock.f_54117_);
        BlockState vanillaState = (BlockState)((BlockState)vanillaBedBlock.m_49966_().m_61124_((Property)BedBlock.f_54117_, (Comparable)facing)).m_61124_((Property)BedBlock.f_49440_, (Comparable)BedPart.HEAD);
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, 0.0, 0.5);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(-facing.m_122435_()));
        poseStack.m_85837_(-0.5, 0.0, -0.5);
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        float seemingOffset = RenderUtils.getSeamOffsetGeneral((Player)player, blockEntity.m_58899_());
        minecraft.m_91289_().m_110912_(vanillaState, poseStack, bufferSource, packedLight, packedOverlay);
        if (!blockEntity.getImageLocation().equals("picaxe:blocks/bed")) {
            switch (blockEntity.renderTypes) {
                case DRAPE_SIDES_PILLOW: {
                    poseStack.m_252781_(Axis.f_252495_.m_252977_(0.0f));
                    poseStack.m_252781_(Axis.f_252436_.m_252977_(0.0f));
                    poseStack.m_85837_(0.5, -0.4672 + (double)seemingOffset, -0.22);
                    ImageUtils.renderImageSideDrapesFromURL(poseStack, bufferSource, packedLight, packedOverlay, partialTick, 0.982f, 1.565f, 0.3f, blockEntity.getImageLocation());
                    break;
                }
                case DRAPE_SIDES_FULL: {
                    poseStack.m_252781_(Axis.f_252495_.m_252977_(0.0f));
                    poseStack.m_252781_(Axis.f_252436_.m_252977_(0.0f));
                    poseStack.m_85837_(0.5, -0.4672 + (double)seemingOffset, 0.0);
                    ImageUtils.renderImageSideDrapesFromURL(poseStack, bufferSource, packedLight, packedOverlay, partialTick, 0.99f, 2.002f, 0.3f, blockEntity.getImageLocation());
                    break;
                }
                case DRAPE_HEAD_AND_FOOT: {
                    poseStack.m_252781_(Axis.f_252495_.m_252977_(0.0f));
                    poseStack.m_252781_(Axis.f_252436_.m_252977_(0.0f));
                    poseStack.m_85837_(0.5, -0.4672 + (double)seemingOffset, 0.0);
                    ImageUtils.renderImageFrontBackDrapesFromURL(poseStack, bufferSource, packedLight, packedOverlay, partialTick, 1.005f, 1.982f, 0.3f, blockEntity.getImageLocation());
                    break;
                }
                case DRAPE_FOOT: {
                    poseStack.m_252781_(Axis.f_252495_.m_252977_(0.0f));
                    poseStack.m_252781_(Axis.f_252436_.m_252977_(0.0f));
                    poseStack.m_85837_(0.5, -0.4672 + (double)seemingOffset, -0.22);
                    ImageUtils.renderImageFrontDrapeFromURL(poseStack, bufferSource, packedLight, packedOverlay, partialTick, 1.005f, 1.542f, 0.3f, blockEntity.getImageLocation());
                    break;
                }
                case NO_DRAPES_PILLOW: {
                    poseStack.m_252781_(Axis.f_252495_.m_252977_(0.0f));
                    poseStack.m_252781_(Axis.f_252436_.m_252977_(0.0f));
                    poseStack.m_85837_(0.0, -0.4572 + (double)seemingOffset, -0.72);
                    ImageUtils.renderImageFromURL(poseStack, bufferSource, packedLight, packedOverlay, partialTick, 1.005f, 1.565f, blockEntity.getImageLocation());
                    break;
                }
                case NO_DRAPES_FULL: {
                    poseStack.m_252781_(Axis.f_252495_.m_252977_(0.0f));
                    poseStack.m_252781_(Axis.f_252436_.m_252977_(0.0f));
                    poseStack.m_85837_(0.0, -0.4572 + (double)seemingOffset, -0.5);
                    ImageUtils.renderImageFromURL(poseStack, bufferSource, packedLight, packedOverlay, partialTick, 1.005f, 2.01f, blockEntity.getImageLocation());
                    break;
                }
                default: {
                    poseStack.m_252781_(Axis.f_252495_.m_252977_(0.0f));
                    poseStack.m_252781_(Axis.f_252436_.m_252977_(0.0f));
                    poseStack.m_85837_(0.0, -0.4573 + (double)seemingOffset, -0.5);
                    ImageUtils.renderImageFromURL(poseStack, bufferSource, packedLight, packedOverlay, partialTick, 1.005f, 2.01f, blockEntity.getImageLocation());
                }
            }
        }
        poseStack.m_85849_();
    }
}

