/*
 * Decompiled with CFR 0.152.
 */
package net.jacobwasbeast.picaxe.items;

import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import net.jacobwasbeast.picaxe.ModItems;
import net.jacobwasbeast.picaxe.blocks.SixSidedImageBlock;
import net.jacobwasbeast.picaxe.blocks.entities.SixSidedImageBlockEntity;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Equipable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class SixSidedImageBlockItem
extends BlockItem
implements Equipable {
    public SixSidedImageBlockItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    public static ItemStack create(Map<Direction, String> imageUrls) {
        ItemStack stack = new ItemStack((ItemLike)ModItems.SIX_SIDED_IMAGE_BLOCK_ITEM.get());
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("id", "picaxe:six_sided_image_block");
        for (Map.Entry<Direction, String> entry : imageUrls.entrySet()) {
            tag.m_128359_("image_url_" + entry.getKey().m_122433_(), entry.getValue());
        }
        stack.m_41784_().m_128365_("BlockEntityTag", (Tag)tag);
        return stack;
    }

    public static Map<Direction, String> getImageUrls(ItemStack stack) {
        CompoundTag tag = stack.m_41737_("BlockEntityTag");
        if (tag != null) {
            EnumMap<Direction, String> imageUrls = new EnumMap<Direction, String>(Direction.class);
            for (Direction dir : Direction.values()) {
                String url = tag.m_128461_("image_url_" + dir.m_122433_());
                if (url.isEmpty()) continue;
                imageUrls.put(dir, url);
            }
            return imageUrls;
        }
        return Collections.emptyMap();
    }

    public EquipmentSlot m_40402_() {
        return EquipmentSlot.HEAD;
    }

    protected boolean m_7429_(BlockPlaceContext blockPlaceContext, BlockState blockState) {
        boolean isLit = false;
        try {
            isLit = blockPlaceContext.m_43722_().m_41737_("BlockEntityTag").m_128471_("lit");
        }
        catch (Exception exception) {
            // empty catch block
        }
        blockState = (BlockState)blockState.m_61124_((Property)SixSidedImageBlock.LIT, (Comparable)Boolean.valueOf(isLit));
        return super.m_7429_(blockPlaceContext, blockState);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> list, TooltipFlag tooltipFlag) {
        super.m_7373_(stack, level, list, tooltipFlag);
        boolean isLit = false;
        CompoundTag custom = stack.m_41737_("BlockEntityTag");
        if (custom != null) {
            isLit = custom.m_128471_("lit");
        }
        list.add((Component)Component.m_237110_((String)"tooltip.picaxe.six_sided.lit", (Object[])new Object[]{Component.m_237115_((String)(isLit ? "tooltip.picaxe.state.true" : "tooltip.picaxe.state.false"))}).m_130940_(isLit ? ChatFormatting.GREEN : ChatFormatting.RED));
        Map<Direction, String> urls = SixSidedImageBlockItem.getImageUrls(stack);
        if (!urls.isEmpty()) {
            list.add((Component)Component.m_237119_());
            for (Map.Entry<Direction, String> e : urls.entrySet()) {
                Direction dir = e.getKey();
                String url = e.getValue();
                list.add((Component)Component.m_237110_((String)"tooltip.picaxe.six_sided.image", (Object[])new Object[]{dir.m_122433_().toUpperCase(), Component.m_237113_((String)url).m_130940_(ChatFormatting.AQUA)}).m_130940_(ChatFormatting.GRAY));
            }
        }
    }

    public InteractionResult m_6225_(UseOnContext useOnContext) {
        boolean shouldRemove = false;
        Level level = useOnContext.m_43725_();
        Player player = useOnContext.m_43723_();
        ItemStack mainStack = player.m_21205_();
        ItemStack offStack = player.m_21206_();
        if (mainStack.m_150930_((Item)this) && offStack.m_150930_(Items.f_42398_)) {
            boolean isLit = false;
            try {
                CompoundTag customData = mainStack.m_41737_("BlockEntityTag");
                isLit = customData.m_128471_("lit");
            }
            catch (Exception customData) {
                // empty catch block
            }
            if (isLit) {
                shouldRemove = true;
            }
        }
        if (!shouldRemove) {
            return super.m_6225_(useOnContext);
        }
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        SixSidedImageBlockEntity entity = SixSidedImageBlockEntity.fromItemStack(mainStack);
        entity.m_155250_((BlockState)entity.m_58900_().m_61124_((Property)SixSidedImageBlock.LIT, (Comparable)Boolean.valueOf(false)));
        ItemStack newStack = entity.createItemStack();
        newStack.m_41764_(mainStack.m_41613_());
        player.m_21008_(useOnContext.m_43724_(), newStack);
        ItemStack glowStone = new ItemStack((ItemLike)Items.f_42054_, newStack.m_41613_());
        if (!player.m_150109_().m_36054_(glowStone)) {
            player.m_36176_(glowStone, false);
        }
        return InteractionResult.SUCCESS;
    }
}

