/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.domumornamentum.jei;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.ldtteam.domumornamentum.IDomumOrnamentumApi;
import com.ldtteam.domumornamentum.block.IMateriallyTexturedBlock;
import com.ldtteam.domumornamentum.block.IMateriallyTexturedBlockComponent;
import com.ldtteam.domumornamentum.block.IMateriallyTexturedBlockManager;
import com.ldtteam.domumornamentum.block.ModBlocks;
import com.ldtteam.domumornamentum.item.interfaces.IDoItem;
import com.ldtteam.domumornamentum.jei.JEIPlugin;
import com.ldtteam.domumornamentum.recipe.architectscutter.ArchitectsCutterRecipe;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class ArchitectsCutterCategory
implements IRecipeCategory<ArchitectsCutterRecipe> {
    public static final RecipeType<ArchitectsCutterRecipe> TYPE = RecipeType.create((String)"domum_ornamentum", (String)"architects_cutter", ArchitectsCutterRecipe.class);
    private static final int JEI_OFFSET_X = 55;
    private static final int JEI_OFFSET_Y = 14;
    private final JEIPlugin plugin;
    private final IDrawable background;
    private final IDrawable thumb;
    private final IDrawable slot;
    private final IDrawable button;
    private final IDrawable icon;
    private final LoadingCache<ArchitectsCutterRecipe, DisplayData> cachedDisplayData;

    public ArchitectsCutterCategory(@NotNull IGuiHelper guiHelper, @NotNull JEIPlugin plugin) {
        this.plugin = plugin;
        ResourceLocation texture = new ResourceLocation("domum_ornamentum", "textures/gui/container/architectscutter2.png");
        this.background = guiHelper.createDrawable(texture, 55, 14, 178, 88);
        this.thumb = guiHelper.createDrawable(texture, 12, 220, 12, 15);
        this.slot = guiHelper.createDrawable(texture, 48, 202, 18, 18);
        this.button = guiHelper.createDrawable(texture, 32, 202, 16, 18);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)IDomumOrnamentumApi.getInstance().getBlocks().getArchitectsCutter()));
        this.cachedDisplayData = CacheBuilder.newBuilder().maximumSize(25L).build((CacheLoader)new CacheLoader<ArchitectsCutterRecipe, DisplayData>(){

            @NotNull
            public DisplayData load(@NotNull ArchitectsCutterRecipe key) {
                return new DisplayData(key);
            }
        });
    }

    @NotNull
    public RecipeType<ArchitectsCutterRecipe> getRecipeType() {
        return TYPE;
    }

    @NotNull
    public Component getTitle() {
        return Component.m_237115_((String)"domum_ornamentum.architectscutter");
    }

    @NotNull
    public IDrawable getBackground() {
        return this.background;
    }

    @NotNull
    public IDrawable getIcon() {
        return this.icon;
    }

    @Nullable
    public ResourceLocation getRegistryName(@NotNull ArchitectsCutterRecipe recipe) {
        return recipe.m_6423_();
    }

    public void setRecipe(@NotNull IRecipeLayoutBuilder builder, @NotNull ArchitectsCutterRecipe recipe, @NotNull IFocusGroup focuses) {
        Block generatedBlock = (Block)ForgeRegistries.BLOCKS.getValue(recipe.getBlockName());
        if (!(generatedBlock instanceof IMateriallyTexturedBlock)) {
            return;
        }
        IMateriallyTexturedBlock materiallyTexturedBlock = (IMateriallyTexturedBlock)generatedBlock;
        Collection<IMateriallyTexturedBlockComponent> components = materiallyTexturedBlock.getComponents();
        List inputs = components.stream().map(component -> ForgeRegistries.BLOCKS.tags().getTag(component.getValidSkins()).stream().map(ItemStack::new).collect(Collectors.collectingAndThen(Collectors.toCollection(ArrayList::new), list -> {
            Collections.shuffle(list);
            return list;
        }))).collect(Collectors.toList());
        List defaultInputs = components.stream().map(component -> new ItemStack((ItemLike)component.getDefault())).collect(Collectors.toList());
        DisplayData displayData = (DisplayData)this.cachedDisplayData.getUnchecked((Object)recipe);
        Container container = displayData.getIngredientContainer();
        for (int i = 0; i < defaultInputs.size(); ++i) {
            container.m_6836_(i, (ItemStack)defaultInputs.get(i));
        }
        ItemStack output = recipe.m_5874_(container, null);
        if (output.m_41619_()) {
            output = recipe.m_8043_(null);
            if (output.m_41619_()) {
                output = new ItemStack((ItemLike)generatedBlock);
            }
            output.m_41764_(Math.max(components.size(), recipe.getCount()));
        }
        displayData.setOutput(output);
        builder.addSlot(RecipeIngredientRole.OUTPUT, 128, 63).setCustomRenderer((IIngredientType)VanillaTypes.ITEM_STACK, (IIngredientRenderer)new OutputRenderer(this.plugin, displayData)).addItemStack(output);
        for (int slot = 0; slot < IMateriallyTexturedBlockManager.getInstance().getMaxTexturableComponentCount(); ++slot) {
            int x = 41;
            int y = 52 + slot * 20;
            builder.addSlot(RecipeIngredientRole.INPUT, 41, y).setBackground(this.slot, -1, -1).addItemStacks(slot < inputs.size() ? (List)inputs.get(slot) : Collections.emptyList());
        }
    }

    @NotNull
    public List<Component> getTooltipStrings(@NotNull ArchitectsCutterRecipe recipe, @NotNull IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        Rect2i recipeButton;
        ArrayList<Component> tooltips = new ArrayList<Component>();
        Rect2i groupButton = new Rect2i(2, 3, this.button.getWidth(), this.button.getHeight());
        if (groupButton.m_110087_((int)mouseX, (int)mouseY)) {
            DisplayData displayData = (DisplayData)this.cachedDisplayData.getUnchecked((Object)recipe);
            tooltips.add((Component)Component.m_237115_((String)("cuttergroup." + displayData.getGroupId().m_135827_() + "." + displayData.getGroupId().m_135815_())));
        }
        if ((recipeButton = new Rect2i(2, 26, this.button.getWidth(), this.button.getHeight())).m_110087_((int)mouseX, (int)mouseY)) {
            DisplayData displayData = (DisplayData)this.cachedDisplayData.getUnchecked((Object)recipe);
            tooltips.add(displayData.getOutput().m_41786_());
        }
        return tooltips;
    }

    public void draw(@NotNull ArchitectsCutterRecipe recipe, @NotNull IRecipeSlotsView recipeSlotsView, @NotNull GuiGraphics stack, double mouseX, double mouseY) {
        DisplayData displayData = (DisplayData)this.cachedDisplayData.getUnchecked((Object)recipe);
        displayData.reassembleIfNeeded(recipeSlotsView.getSlotViews(RecipeIngredientRole.INPUT));
        this.thumb.draw(stack, 165, 3);
        this.thumb.draw(stack, 165, 26);
        this.drawButton(stack, 2, 3, displayData.getGroup());
        this.drawButton(stack, 2, 26, displayData.getOutput());
    }

    private void drawButton(@NotNull GuiGraphics stack, int x, int y, @NotNull ItemStack item) {
        this.button.draw(stack, x, y);
        PoseStack pose = stack.m_280168_();
        pose.m_85836_();
        pose.m_252880_((float)x, (float)(y + 1), 0.0f);
        ItemStack buttonStack = item.m_41777_();
        buttonStack.m_41764_(1);
        this.plugin.getIngredientManager().getIngredientRenderer((IIngredientType)VanillaTypes.ITEM_STACK).render(stack, (Object)buttonStack);
        pose.m_85849_();
    }

    private static class DisplayData {
        private final ArchitectsCutterRecipe recipe;
        private ResourceLocation groupId = new ResourceLocation("");
        private ItemStack group = ItemStack.f_41583_;
        private ItemStack output = ItemStack.f_41583_;
        private final Container ingredientContainer = new SimpleContainer(IMateriallyTexturedBlockManager.getInstance().getMaxTexturableComponentCount());

        public DisplayData(@NotNull ArchitectsCutterRecipe recipe) {
            this.recipe = recipe;
        }

        @NotNull
        public Container getIngredientContainer() {
            return this.ingredientContainer;
        }

        @NotNull
        public ResourceLocation getGroupId() {
            return this.groupId;
        }

        @NotNull
        public ItemStack getGroup() {
            return this.group;
        }

        @NotNull
        public ItemStack getOutput() {
            return this.output;
        }

        public void setOutput(@NotNull ItemStack output) {
            Item item = output.m_41720_();
            if (item instanceof IDoItem) {
                IDoItem doItem = (IDoItem)item;
                this.groupId = doItem.getGroup();
                this.group = ModBlocks.getInstance().getOrComputeItemGroups().getOrDefault(this.groupId, Collections.singletonList(ItemStack.f_41583_)).get(0);
            } else {
                this.groupId = new ResourceLocation("");
                this.group = ItemStack.f_41583_;
            }
            this.output = output;
        }

        public void reassembleIfNeeded(@NotNull List<IRecipeSlotView> slotViews) {
            boolean same = true;
            for (int i = 0; i < slotViews.size(); ++i) {
                Optional currentItem = slotViews.get(i).getDisplayedItemStack();
                if (!currentItem.isPresent() || ItemStack.m_150942_((ItemStack)((ItemStack)currentItem.get()), (ItemStack)this.ingredientContainer.m_8020_(i))) continue;
                same = false;
                this.ingredientContainer.m_6836_(i, (ItemStack)currentItem.get());
            }
            if (!same) {
                this.output = this.recipe.m_5874_(this.ingredientContainer, null);
            }
        }
    }

    private static class OutputRenderer
    implements IIngredientRenderer<ItemStack> {
        private final JEIPlugin plugin;
        private final DisplayData displayData;
        private IIngredientRenderer<ItemStack> renderer;

        public OutputRenderer(@NotNull JEIPlugin plugin, @NotNull DisplayData displayData) {
            this.plugin = plugin;
            this.displayData = displayData;
        }

        private IIngredientRenderer<ItemStack> getRenderer() {
            if (this.renderer == null) {
                this.renderer = this.plugin.getIngredientManager().getIngredientRenderer((IIngredientType)VanillaTypes.ITEM_STACK);
            }
            return this.renderer;
        }

        public void render(@NotNull GuiGraphics stack, @NotNull ItemStack ingredient) {
            this.getRenderer().render(stack, (Object)this.displayData.getOutput());
        }

        @NotNull
        public List<Component> getTooltip(@NotNull ItemStack ingredient, @NotNull TooltipFlag tooltipFlag) {
            return this.getRenderer().getTooltip((Object)this.displayData.getOutput(), tooltipFlag);
        }

        @NotNull
        public Font getFontRenderer(@NotNull Minecraft minecraft, @NotNull ItemStack ingredient) {
            return this.getRenderer().getFontRenderer(minecraft, (Object)this.displayData.getOutput());
        }

        public int getWidth() {
            return 16;
        }

        public int getHeight() {
            return 16;
        }
    }
}

