/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.items;

import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.data.ItemModelGenerator;
import de.ellpeck.naturesaura.items.ItemImpl;
import de.ellpeck.naturesaura.misc.ColoredBlockHelper;
import de.ellpeck.naturesaura.reg.IColorProvidingItem;
import de.ellpeck.naturesaura.reg.ICustomItemModel;
import java.util.List;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemColorChanger
extends ItemImpl
implements IColorProvidingItem,
ICustomItemModel {
    public ItemColorChanger() {
        super("color_changer", new Item.Properties().m_41487_(1));
    }

    private static boolean changeOrCopyColor(Player player, ItemStack stack, Level level, BlockPos pos, DyeColor firstColor) {
        Block block = level.m_8055_(pos).m_60734_();
        List<Block> blocks = ColoredBlockHelper.getBlocksContaining(block);
        if (blocks == null) {
            return false;
        }
        DyeColor color = DyeColor.m_41053_((int)blocks.indexOf(block));
        if (firstColor == null || color == firstColor) {
            DyeColor stored = ItemColorChanger.getStoredColor(stack);
            if (player.m_6144_()) {
                if (stored != color) {
                    level.m_6263_(player, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, SoundEvents.f_11781_, SoundSource.PLAYERS, 0.65f, 1.0f);
                    if (!level.f_46443_) {
                        ItemColorChanger.storeColor(stack, color);
                    }
                    return true;
                }
            } else if (stored != null && stored != color && NaturesAuraAPI.instance().extractAuraFromPlayer(player, 1000, level.f_46443_)) {
                if (firstColor == null) {
                    level.m_6263_(player, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, SoundEvents.f_11778_, SoundSource.PLAYERS, 0.65f, 1.0f);
                }
                if (!level.f_46443_) {
                    level.m_46597_(pos, blocks.get(stored.m_41060_()).m_49966_());
                    if (ItemColorChanger.isFillMode(stack)) {
                        for (Direction off : Direction.values()) {
                            ItemColorChanger.changeOrCopyColor(player, stack, level, pos.m_121945_(off), color);
                        }
                    }
                }
                return true;
            }
        }
        return false;
    }

    public static DyeColor getStoredColor(ItemStack stack) {
        if (!stack.m_41782_()) {
            return null;
        }
        int color = stack.m_41783_().m_128451_("color");
        return DyeColor.m_41053_((int)color);
    }

    private static void storeColor(ItemStack stack, DyeColor color) {
        stack.m_41784_().m_128405_("color", color.m_41060_());
    }

    public static boolean isFillMode(ItemStack stack) {
        if (!stack.m_41782_()) {
            return false;
        }
        return stack.m_41783_().m_128471_("fill");
    }

    private static void setFillMode(ItemStack stack, boolean fill) {
        stack.m_41784_().m_128379_("fill", fill);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        ItemStack stack = context.m_43723_().m_21120_(context.m_43724_());
        if (ItemColorChanger.changeOrCopyColor(context.m_43723_(), stack, context.m_43725_(), context.m_8083_(), null)) {
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level levelIn, Player playerIn, InteractionHand handIn) {
        ItemStack stack = playerIn.m_21120_(handIn);
        if (playerIn.m_6144_() && ItemColorChanger.getStoredColor(stack) != null) {
            levelIn.m_6263_(playerIn, playerIn.m_20185_(), playerIn.m_20186_(), playerIn.m_20189_(), SoundEvents.f_11783_, SoundSource.PLAYERS, 0.65f, 1.0f);
            if (!levelIn.f_46443_) {
                ItemColorChanger.setFillMode(stack, !ItemColorChanger.isFillMode(stack));
            }
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
        }
        return new InteractionResultHolder(InteractionResult.PASS, (Object)stack);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ItemColor getItemColor() {
        return (stack, tintIndex) -> {
            DyeColor color;
            if (tintIndex > 0 && (color = ItemColorChanger.getStoredColor(stack)) != null) {
                return color.m_41070_();
            }
            return 0xFFFFFF;
        };
    }

    @Override
    public void generateCustomItemModel(ItemModelGenerator generator) {
    }
}

