/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.utilitix.compat.jade;

import de.melanx.utilitix.UtilitiX;
import de.melanx.utilitix.compat.jade.UtilJade;
import de.melanx.utilitix.content.brewery.TileAdvancedBrewery;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.IElementHelper;
import snownee.jade.impl.ui.ElementHelper;

public class AdvancedBreweryProvider
implements IBlockComponentProvider,
IServerDataProvider<BlockAccessor> {
    public static final ResourceLocation UID = UtilitiX.getInstance().resource("advanced_brewery");
    public static final AdvancedBreweryProvider INSTANCE = new AdvancedBreweryProvider();
    private static final ItemStack BLAZE_POWDER = new ItemStack((ItemLike)Items.f_42593_);
    private static final ItemStack CLOCK = new ItemStack((ItemLike)Items.f_42524_);

    public ResourceLocation getUid() {
        return UID;
    }

    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        if (!config.get(UtilJade.ADVANCED_BREWERY)) {
            return;
        }
        CompoundTag tag = accessor.getServerData().m_128469_("AdvancedBrewery");
        int fuel = tag.m_128451_("fuel");
        int time = tag.m_128451_("time");
        IElementHelper helper = tooltip.getElementHelper();
        tooltip.add(helper.smallItem(BLAZE_POWDER));
        tooltip.append(helper.text((Component)Component.m_237115_((String)Integer.toString(fuel))));
        if (time > 0 && time != 400) {
            tooltip.append(helper.spacer(5, 0));
            tooltip.append(helper.item(CLOCK, 0.75f));
            tooltip.append(helper.text((Component)Component.m_237110_((String)"jade.seconds", (Object[])new Object[]{time / 20})).translate(ElementHelper.SMALL_ITEM_OFFSET));
        }
    }

    public void appendServerData(CompoundTag data, BlockAccessor blockAccessor) {
        TileAdvancedBrewery brewery = (TileAdvancedBrewery)blockAccessor.getBlockEntity();
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("time", 400 - brewery.getBrewTime());
        tag.m_128405_("fuel", brewery.getFuel());
        data.m_128365_("AdvancedBrewery", (Tag)tag);
    }
}

