/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.structures;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.telepathicgrunt.repurposedstructures.modinit.RSStructures;
import com.telepathicgrunt.repurposedstructures.utils.GeneralUtils;
import com.telepathicgrunt.repurposedstructures.world.structures.GenericJigsawStructure;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;

public class CityNetherStructure
extends GenericJigsawStructure {
    public static final Codec<CityNetherStructure> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)CityNetherStructure.m_226567_((RecordCodecBuilder.Instance)instance), (App)StructureTemplatePool.f_210555_.fieldOf("start_pool").forGetter(structure -> structure.startPool), (App)Codec.intRange((int)0, (int)30).fieldOf("size").forGetter(structure -> structure.size), (App)Codec.INT.optionalFieldOf("min_y_allowed").forGetter(structure -> structure.minYAllowed), (App)Codec.INT.optionalFieldOf("max_y_allowed").forGetter(structure -> structure.maxYAllowed), (App)Codec.intRange((int)1, (int)1000).optionalFieldOf("allowed_y_range_from_start").forGetter(structure -> structure.allowedYRangeFromStart), (App)HeightProvider.f_161970_.fieldOf("start_height").forGetter(structure -> structure.startHeight), (App)Heightmap.Types.f_64274_.optionalFieldOf("project_start_to_heightmap").forGetter(structure -> structure.projectStartToHeightmap), (App)Codec.BOOL.fieldOf("cannot_spawn_in_liquid").orElse((Object)false).forGetter(structure -> structure.cannotSpawnInLiquid), (App)Codec.intRange((int)1, (int)100).optionalFieldOf("terrain_height_radius_check").forGetter(structure -> structure.terrainHeightCheckRadius), (App)Codec.intRange((int)1, (int)1000).optionalFieldOf("allowed_terrain_height_range").forGetter(structure -> structure.allowedTerrainHeightRange), (App)Codec.intRange((int)1, (int)100).optionalFieldOf("valid_biome_radius_check").forGetter(structure -> structure.biomeRadius), (App)ResourceLocation.f_135803_.listOf().fieldOf("pools_that_ignore_boundaries").orElse(new ArrayList()).xmap(HashSet::new, ArrayList::new).forGetter(structure -> structure.poolsThatIgnoreBoundaries), (App)Codec.intRange((int)1, (int)128).optionalFieldOf("max_distance_from_center").forGetter(structure -> structure.maxDistanceFromCenter), (App)StringRepresentable.m_216439_(GenericJigsawStructure.BURYING_TYPE::values).optionalFieldOf("burying_type").forGetter(structure -> structure.buryingType), (App)Codec.BOOL.fieldOf("use_bounding_box_hack").orElse((Object)false).forGetter(structure -> structure.useBoundingBoxHack)).apply((Applicative)instance, CityNetherStructure::new));

    public CityNetherStructure(Structure.StructureSettings config, Holder<StructureTemplatePool> startPool, int size, Optional<Integer> minYAllowed, Optional<Integer> maxYAllowed, Optional<Integer> allowedYRangeFromStart, HeightProvider startHeight, Optional<Heightmap.Types> projectStartToHeightmap, boolean cannotSpawnInLiquid, Optional<Integer> terrainHeightCheckRadius, Optional<Integer> allowedTerrainHeightRange, Optional<Integer> biomeRadius, HashSet<ResourceLocation> poolsThatIgnoreBoundaries, Optional<Integer> maxDistanceFromCenter, Optional<GenericJigsawStructure.BURYING_TYPE> buryingType, boolean useBoundingBoxHack) {
        super(config, startPool, size, minYAllowed, maxYAllowed, allowedYRangeFromStart, startHeight, projectStartToHeightmap, cannotSpawnInLiquid, terrainHeightCheckRadius, allowedTerrainHeightRange, biomeRadius, poolsThatIgnoreBoundaries, maxDistanceFromCenter, buryingType, useBoundingBoxHack);
    }

    @Override
    protected boolean extraSpawningChecks(Structure.GenerationContext context, BlockPos blockPos) {
        boolean superCheck = super.extraSpawningChecks(context, blockPos);
        if (!superCheck) {
            return false;
        }
        ChunkPos chunkPos = new ChunkPos(blockPos);
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (int curChunkX = chunkPos.f_45578_ - 1; curChunkX <= chunkPos.f_45578_ + 1; ++curChunkX) {
            for (int curChunkZ = chunkPos.f_45579_ - 1; curChunkZ <= chunkPos.f_45579_ + 1; ++curChunkZ) {
                mutable.m_122178_(curChunkX << 4, context.f_226622_().m_6337_() + 10, curChunkZ << 4);
                NoiseColumn blockView = context.f_226622_().m_214184_(mutable.m_123341_(), mutable.m_123343_(), context.f_226629_(), context.f_226624_());
                int minValidSpace = 65;
                int maxHeight = Math.min(GeneralUtils.getMaxTerrainLimit(context.f_226622_()), context.f_226622_().m_6337_() + minValidSpace);
                while (mutable.m_123342_() < maxHeight) {
                    BlockState state = blockView.m_183556_(mutable.m_123342_());
                    if (!state.m_60795_()) {
                        return false;
                    }
                    mutable.m_122173_(Direction.UP);
                }
            }
        }
        return true;
    }

    @Override
    public StructureType<?> m_213658_() {
        return RSStructures.CITY_NETHER_STRUCTURE.get();
    }
}

