/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.configuration.client;

import dev.toma.configuration.client.screen.ConfigGroupScreen;
import dev.toma.configuration.client.screen.ConfigScreen;
import dev.toma.configuration.client.theme.ConfigTheme;
import dev.toma.configuration.client.theme.ConfigurationThemes;
import dev.toma.configuration.config.Config;
import dev.toma.configuration.config.ConfigHolder;
import dev.toma.configuration.config.value.ConfigValue;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.client.gui.screens.Screen;
import org.jetbrains.annotations.ApiStatus;

public final class ConfigurationClient {
    @ApiStatus.Internal
    private static final Map<String, ConfigTheme> CONFIG_THEMES = new HashMap<String, ConfigTheme>();

    public static Screen getConfigScreen(Class<?> configClass, Screen previous) {
        Config cfg = configClass.getAnnotation(Config.class);
        if (cfg == null) {
            return null;
        }
        String id = cfg.id();
        return ConfigurationClient.getConfigScreen(id, previous);
    }

    public static Screen getConfigScreen(String configId, Screen previous) {
        return ConfigHolder.getConfig(configId).map(holder -> {
            Map<String, ConfigValue<?>> valueMap = holder.getValueMap();
            return new ConfigScreen((ConfigHolder<?>)holder, holder.getTitle(), valueMap, previous);
        }).orElse(null);
    }

    public static Screen getConfigScreenByGroup(String group, Screen previous) {
        List<ConfigHolder<?>> list = ConfigHolder.getConfigsByGroup(group);
        if (list.isEmpty()) {
            return null;
        }
        return ConfigurationClient.getConfigScreenByGroup(list, group, previous);
    }

    public static void setCustomConfigTheme(ConfigHolder<?> holder, Consumer<ConfigTheme> themeConfiguration) {
        ConfigTheme theme = ConfigurationClient.getConfigTheme(holder).copy();
        themeConfiguration.accept(theme);
        CONFIG_THEMES.put(holder.getConfigId(), theme);
    }

    public static ConfigTheme getConfigTheme(ConfigHolder<?> holder) {
        return CONFIG_THEMES.computeIfAbsent(holder.getConfigId(), id -> {
            ConfigTheme theme = new ConfigTheme();
            ConfigurationThemes.DEFAULT_THEME.accept(theme);
            return theme;
        });
    }

    @ApiStatus.Internal
    public static Screen getConfigScreenByGroup(List<ConfigHolder<?>> group, String groupId, Screen previous) {
        return new ConfigGroupScreen(previous, groupId, group);
    }
}

