/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.configuration.client.widget;

import dev.toma.configuration.client.screen.DialogScreen;
import dev.toma.configuration.client.theme.ConfigTheme;
import dev.toma.configuration.client.widget.AbstractThemeWidget;
import dev.toma.configuration.config.Configurable;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;

public final class ColorWidget
extends AbstractThemeWidget {
    public static final Component SELECT_COLOR = Component.m_237115_((String)"text.configuration.screen.color_dialog");
    private final boolean argb;
    private final String colorPrefix;
    private final IntSupplier colorSupplier;
    private final GetSet<String> colorWidget;
    private final Screen lastScreen;

    public ColorWidget(int x, int y, int width, int height, ConfigTheme theme, Configurable.Gui.ColorValue colorOptions, GetSet<String> colorWidget, Screen lastScreen) {
        super(x, y, width, height, theme);
        this.argb = colorOptions.isARGB();
        this.colorPrefix = colorOptions.getGuiColorPrefix();
        this.colorWidget = colorWidget;
        this.colorSupplier = () -> {
            String rawColor = (String)colorWidget.get();
            try {
                long longClr = Long.decode(rawColor);
                return (int)longClr;
            }
            catch (NumberFormatException e) {
                return 0;
            }
        };
        this.lastScreen = lastScreen;
    }

    public void m_87963_(GuiGraphics graphics, int mouseX, int mouseY, float partialRenderTicks) {
        int providedColor = this.colorSupplier.getAsInt();
        int color = this.argb ? providedColor : 0xFF000000 | providedColor;
        this.renderBackground(graphics);
        graphics.m_280024_(this.m_252754_() + 1, this.m_252907_() + 1, this.getRight() - 1, this.getBottom() - 1, -1, -7829368);
        graphics.m_280509_(this.m_252754_() + 1, this.m_252907_() + 1, this.getRight() - 1, this.getBottom() - 1, color);
    }

    protected boolean m_7972_(int button) {
        return button == 0;
    }

    public void m_5716_(double mouseX, double mouseY) {
        ColorSelectorDialog dialog = new ColorSelectorDialog(SELECT_COLOR, this.lastScreen, this.argb, this.colorSupplier);
        dialog.onConfirmed(screen -> {
            int color = dialog.getResultColor();
            String colorText = this.colorPrefix + Integer.toHexString(color).toUpperCase();
            this.colorWidget.set(colorText);
            dialog.displayPreviousScreen();
        });
        Minecraft.m_91087_().m_91152_((Screen)dialog);
    }

    @Override
    public void m_168797_(NarrationElementOutput elementOutput) {
    }

    public static interface GetSet<T> {
        public T get();

        public void set(T var1);

        public static <T> GetSet<T> of(final Supplier<T> get, final Consumer<T> set) {
            return new GetSet<T>(){

                @Override
                public T get() {
                    return get.get();
                }

                @Override
                public void set(T t) {
                    set.accept(t);
                }
            };
        }
    }

    private static final class ColorSelectorDialog
    extends DialogScreen {
        private final boolean argb;
        private final IntSupplier colorProvider;
        private final List<ColorSlider> sliders = new ArrayList<ColorSlider>();

        public ColorSelectorDialog(Component title, Screen background, boolean allowTransparency, IntSupplier colorProvider) {
            super(title, new Component[0], background);
            this.argb = allowTransparency;
            this.colorProvider = colorProvider;
        }

        @Override
        protected void m_7856_() {
            this.sliders.clear();
            int width = 190;
            int height = 120;
            int rightMargin = 85;
            if (this.argb) {
                height = 150;
                rightMargin = 110;
                width = 230;
            }
            super.m_7856_();
            this.setDimensions(width, height);
            int color = this.colorProvider.getAsInt();
            this.sliders.add((ColorSlider)this.m_142416_((GuiEventListener)new ColorSlider(this.dialogLeft + 5, this.dialogTop + 20, this.dialogWidth - rightMargin, 20, color, ColorComponent.RED)));
            this.sliders.add((ColorSlider)this.m_142416_((GuiEventListener)new ColorSlider(this.dialogLeft + 5, this.dialogTop + 45, this.dialogWidth - rightMargin, 20, color, ColorComponent.GREEN)));
            this.sliders.add((ColorSlider)this.m_142416_((GuiEventListener)new ColorSlider(this.dialogLeft + 5, this.dialogTop + 70, this.dialogWidth - rightMargin, 20, color, ColorComponent.BLUE)));
            if (this.argb) {
                this.sliders.add((ColorSlider)this.m_142416_((GuiEventListener)new ColorSlider(this.dialogLeft + 5, this.dialogTop + 95, this.dialogWidth - rightMargin, 20, color, ColorComponent.ALPHA)));
            }
            this.m_142416_((GuiEventListener)new ColorDisplay(this.dialogLeft + 5 + this.dialogWidth - rightMargin + 5, this.dialogTop + 20, rightMargin - 15, rightMargin - 15, this.argb, this::getResultColor));
            super.addDefaultDialogButtons();
        }

        @Override
        protected void addDefaultDialogButtons() {
        }

        public int getResultColor() {
            int color = 0;
            for (ColorSlider slider : this.sliders) {
                color |= slider.getColor();
            }
            return color;
        }

        private static final class ColorSlider
        extends AbstractSliderButton {
            private final ColorComponent colorComponent;

            public ColorSlider(int x, int y, int width, int height, int color, ColorComponent colorComponent) {
                super(x, y, width, height, CommonComponents.f_237098_, (double)colorComponent.getByteColor(color) / 255.0);
                this.colorComponent = colorComponent;
                this.m_5695_();
            }

            protected void m_5695_() {
                Component colorLabel = this.colorComponent.updateTitle(this.f_93577_);
                this.m_93666_(colorLabel);
            }

            protected void m_5697_() {
            }

            int getColor() {
                return this.colorComponent.getOffsetColor((int)(255.0 * this.f_93577_));
            }
        }

        private static enum ColorComponent {
            ALPHA(24),
            RED(16),
            GREEN(8),
            BLUE(0);

            private final int bitOffset;
            private final Function<Double, Component> title;

            private ColorComponent(int bitOffset) {
                this.bitOffset = bitOffset;
                this.title = val -> {
                    String name = this.name().toLowerCase();
                    String translate = "text.configuration.screen.color." + name;
                    int colorValue = (int)(val * 255.0);
                    return Component.m_237110_((String)translate, (Object[])new Object[]{colorValue});
                };
            }

            public int getOffsetColor(int value) {
                return value << this.bitOffset;
            }

            public int getByteColor(int value) {
                return value >> this.bitOffset & 0xFF;
            }

            public Component updateTitle(double sliderValue) {
                return this.title.apply(sliderValue);
            }
        }

        private static final class ColorDisplay
        extends AbstractWidget {
            private final boolean argb;
            private final IntSupplier colorProvider;

            public ColorDisplay(int x, int y, int width, int height, boolean argb, IntSupplier colorProvider) {
                super(x, y, width, height, CommonComponents.f_237098_);
                this.argb = argb;
                this.colorProvider = colorProvider;
            }

            public void m_87963_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
                int color = this.colorProvider.getAsInt();
                if (!this.argb) {
                    color |= 0xFF000000;
                }
                int borderColor = -6250336;
                graphics.m_280509_(this.m_252754_(), this.m_252907_(), this.m_252754_() + this.f_93618_, this.m_252907_() + this.f_93619_, borderColor);
                graphics.m_280024_(this.m_252754_() + 1, this.m_252907_() + 1, this.m_252754_() + this.f_93618_ - 1, this.m_252907_() + this.f_93619_ - 1, -1, -7829368);
                graphics.m_280509_(this.m_252754_() + 1, this.m_252907_() + 1, this.m_252754_() + this.f_93618_ - 1, this.m_252907_() + this.f_93619_ - 1, color);
            }

            protected boolean m_7972_(int button) {
                return false;
            }

            public void m_168797_(NarrationElementOutput p_169152_) {
            }
        }
    }
}

