/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.configuration.config;

import dev.toma.configuration.Configuration;
import dev.toma.configuration.config.Configurable;
import dev.toma.configuration.config.adapter.TypeAdapter;
import dev.toma.configuration.config.adapter.TypeAdapterManager;
import dev.toma.configuration.config.adapter.TypeAttributes;
import dev.toma.configuration.config.adapter.TypeMapper;
import dev.toma.configuration.config.format.IConfigFormatHandler;
import dev.toma.configuration.config.io.ConfigIO;
import dev.toma.configuration.config.value.ConfigValue;
import dev.toma.configuration.config.value.IConfigValue;
import dev.toma.configuration.config.value.IConfigValueReadable;
import dev.toma.configuration.config.value.ObjectValue;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.ApiStatus;

public final class ConfigHolder<CFG> {
    private static final Map<String, ConfigHolder<?>> REGISTERED_CONFIGS = new LinkedHashMap();
    private final String configId;
    private final String filename;
    private final String group;
    private final CFG configInstance;
    private final Class<CFG> configClass;
    private final IConfigFormatHandler format;
    private final Map<String, ConfigValue<?>> valueMap = new LinkedHashMap();
    private final Map<String, ConfigValue<?>> networkSerializedFields = new LinkedHashMap();
    private final Component title;
    private final Object lock = new Object();

    public ConfigHolder(Class<CFG> cfgClass, String configId, String filename, String group, IConfigFormatHandler format) {
        this.configClass = cfgClass;
        this.configId = configId;
        this.filename = filename;
        this.group = group;
        try {
            this.configInstance = cfgClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            Configuration.LOGGER.fatal("Failed to instantiate config class for {} config", (Object)configId);
            throw new RuntimeException("Config create failed", e);
        }
        try {
            this.serializeType(this.configClass, this.configInstance, true);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Config serialize failed", e);
        }
        this.format = format;
        this.loadNetworkFields(this.valueMap, this.networkSerializedFields);
        this.title = Component.m_237115_((String)("config.screen." + this.configId));
    }

    @ApiStatus.Internal
    public static void registerConfig(ConfigHolder<?> holder) {
        REGISTERED_CONFIGS.put(holder.configId, holder);
        ConfigIO.processConfig(holder);
    }

    @ApiStatus.Internal
    public static <CFG> Optional<ConfigHolder<CFG>> getConfig(String id) {
        ConfigHolder<?> value = REGISTERED_CONFIGS.get(id);
        return value == null ? Optional.empty() : Optional.of(value);
    }

    @ApiStatus.Internal
    public static Map<String, List<ConfigHolder<?>>> getConfigGroupingByGroup() {
        return REGISTERED_CONFIGS.values().stream().collect(Collectors.groupingBy(ConfigHolder::getGroup));
    }

    @ApiStatus.Internal
    public static List<ConfigHolder<?>> getConfigsByGroup(String group) {
        return REGISTERED_CONFIGS.values().stream().filter(configHolder -> configHolder.group.equals(group)).collect(Collectors.toList());
    }

    @ApiStatus.Internal
    public static Set<String> getSynchronizedConfigs() {
        return REGISTERED_CONFIGS.entrySet().stream().filter(e -> !((ConfigHolder)e.getValue()).networkSerializedFields.isEmpty()).map(Map.Entry::getKey).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public boolean isChanged() {
        return this.values().stream().anyMatch(ConfigValue::isChanged);
    }

    public boolean isChangedFromDefault() {
        return this.values().stream().anyMatch(ConfigValue::isChangedFromDefault);
    }

    public void save() {
        this.values().forEach(ConfigValue::save);
    }

    public void restoreClientStoredValues() {
        this.values().forEach(ConfigValue::clearNetworkValues);
    }

    public <V> Optional<V> getValue(String path, Class<V> expectedType) {
        String[] keys = path.split("\\.");
        Iterator<String> stringIterator = Arrays.asList(keys).iterator();
        return ObjectValue.getChildValue(stringIterator, expectedType, this.valueMap);
    }

    public <V> Optional<IConfigValue<V>> getConfigValue(String path, Class<V> expectedType) {
        String[] keys = path.split("\\.");
        Iterator<String> stringIterator = Arrays.asList(keys).iterator();
        return ObjectValue.getChild(stringIterator, expectedType, this.valueMap);
    }

    public String getConfigId() {
        return this.configId;
    }

    public String getFilename() {
        return this.filename;
    }

    public String getGroup() {
        return this.group;
    }

    public CFG getConfigInstance() {
        return this.configInstance;
    }

    public Class<CFG> getConfigClass() {
        return this.configClass;
    }

    @ApiStatus.Internal
    public IConfigFormatHandler getFormat() {
        return this.format;
    }

    @ApiStatus.Internal
    public Collection<ConfigValue<?>> values() {
        return this.valueMap.values();
    }

    @ApiStatus.Internal
    public Map<String, ConfigValue<?>> getValueMap() {
        return this.valueMap;
    }

    @ApiStatus.Internal
    public Map<String, ConfigValue<?>> getNetworkSerializedFields() {
        return this.networkSerializedFields;
    }

    public Component getTitle() {
        return this.title;
    }

    @ApiStatus.Internal
    public Object getLock() {
        return this.lock;
    }

    @ApiStatus.Internal
    public static Collection<String> getRegisteredConfigs() {
        return REGISTERED_CONFIGS.keySet();
    }

    private <T> Map<String, ConfigValue<?>> serializeType(Class<?> type, Object instance, boolean saveValue) throws IllegalAccessException {
        Field[] fields;
        LinkedHashMap map = new LinkedHashMap();
        for (Field field : fields = type.getFields()) {
            Configurable value = field.getAnnotation(Configurable.class);
            if (value == null) continue;
            int modifiers = field.getModifiers();
            if (Modifier.isStatic(modifiers) || Modifier.isFinal(modifiers)) {
                Configuration.LOGGER.warn(ConfigIO.MARKER, "Skipping config field {}, only instance non-final types are supported", (Object)field);
                continue;
            }
            TypeAttributes<?> attributes = TypeAdapterManager.forType(field.getType());
            TypeAdapter<?> adapter = attributes.adapter();
            if (adapter == null) {
                Configuration.LOGGER.warn(ConfigIO.MARKER, "Missing adapter for type {}, skipping serialization", field.getType());
                continue;
            }
            String[] comments = new String[]{};
            Configurable.Comment comment = field.getAnnotation(Configurable.Comment.class);
            boolean localizeComments = false;
            if (comment != null) {
                comments = comment.value();
                localizeComments = comment.localize();
            }
            Configurable.LocalizationKey localizationType = value.key();
            field.setAccessible(true);
            Object fieldValue = field.get(instance);
            TypeMapper<?, Object> mapper = attributes.mapper();
            Object migratedField = mapper.migrate(fieldValue);
            TypeAdapter.AdapterContext context = this.getAdapterContext(adapter, type, field, mapper, instance);
            TypeAdapter.TypeAttributes<Object> typeAttributes = new TypeAdapter.TypeAttributes<Object>(this.configId, field.getName(), migratedField, context, localizationType, comments, localizeComments);
            ConfigValue<Object> cfgValue = adapter.serialize(typeAttributes, migratedField, (t, i) -> this.serializeType(t, i, false));
            cfgValue.processFieldData(field);
            map.put(field.getName(), cfgValue);
            if (!saveValue) continue;
            this.assignValue(cfgValue);
        }
        return map;
    }

    private <T> void assignValue(ConfigValue<T> value) {
        this.valueMap.put(value.getId(), value);
    }

    private void loadNetworkFields(Map<String, ConfigValue<?>> src, Map<String, ConfigValue<?>> dest) {
        src.values().forEach(value -> {
            if (value instanceof ObjectValue) {
                ObjectValue objValue = (ObjectValue)value;
                Map data = (Map)objValue.get(IConfigValueReadable.Mode.SAVED);
                this.loadNetworkFields(data, dest);
            } else {
                if (!value.shouldSynchronize()) {
                    return;
                }
                String path = value.getPath();
                dest.put(path, (ConfigValue<?>)value);
            }
        });
    }

    private TypeAdapter.AdapterContext getAdapterContext(final TypeAdapter<?> parent, final Class<?> type, final Field field, final TypeMapper<?, Object> mapper, final Object instance) {
        return new TypeAdapter.AdapterContext(){

            @Override
            public TypeAdapter<?> getAdapter() {
                return parent;
            }

            @Override
            public Field getOwner() {
                return field;
            }

            @Override
            public void setFieldValue(Object value) {
                field.setAccessible(true);
                try {
                    Object remapped = mapper.rollback(value);
                    parent.setFieldValue(field, instance, remapped);
                }
                catch (IllegalAccessException e) {
                    Configuration.LOGGER.error(ConfigIO.MARKER, "Failed to update config value for field {} from {} to a new value {} due to error {}", (Object)field.getName(), (Object)type, value, (Object)e);
                }
            }
        };
    }
}

