/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.configuration.config.value;

import dev.toma.configuration.config.adapter.TypeAdapter;
import dev.toma.configuration.config.exception.ConfigValueMissingException;
import dev.toma.configuration.config.format.IConfigFormat;
import dev.toma.configuration.config.value.ConfigValue;
import dev.toma.configuration.config.value.IConfigValueReadable;
import dev.toma.configuration.config.value.ValueData;
import net.minecraft.network.FriendlyByteBuf;

public class EnumValue<E extends Enum<E>>
extends ConfigValue<E> {
    private final String[] additionalComments;

    public EnumValue(ValueData<E> valueData) {
        super(valueData);
        this.additionalComments = EnumValue.generateEnumComments(valueData.getValueType());
    }

    @Override
    protected void serialize(IConfigFormat format) {
        format.addComments(this.additionalComments);
        format.writeEnum(this.getId(), (Enum)this.get(IConfigValueReadable.Mode.SAVED));
    }

    @Override
    protected void deserialize(IConfigFormat format) throws ConfigValueMissingException {
        this.setValue(format.readEnum(this.getId(), this.getValueType()));
    }

    static <E extends Enum<E>> String[] generateEnumComments(Class<E> enumType) {
        String[] comments = new String[((Enum[])enumType.getEnumConstants()).length + 1];
        comments[0] = "Allowed values:";
        for (int i = 0; i < ((Enum[])enumType.getEnumConstants()).length; ++i) {
            comments[i + 1] = "- " + ((Enum[])enumType.getEnumConstants())[i].name();
        }
        return comments;
    }

    public static final class Adapter<E extends Enum<E>>
    extends TypeAdapter<E> {
        @Override
        public ConfigValue<E> serialize(TypeAdapter.TypeAttributes<E> attributes, Object instance, TypeAdapter.TypeSerializer serializer) throws IllegalAccessException {
            return new EnumValue<E>(ValueData.of(attributes));
        }

        @Override
        public void encodeToBuffer(ConfigValue<E> value, FriendlyByteBuf buffer) {
            buffer.m_130068_((Enum)value.get());
        }

        @Override
        public E decodeFromBuffer(ConfigValue<E> value, FriendlyByteBuf buffer) {
            Class<E> type = value.getValueType();
            return (E)buffer.m_130066_(type);
        }
    }
}

