/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.common.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.commons.lang3.tuple.Triple;
import org.jetbrains.annotations.Nullable;
import vazkii.patchouli.common.book.Book;
import vazkii.patchouli.common.book.BookRegistry;
import vazkii.patchouli.common.item.ItemModBook;

public final class ItemStackUtil {
    private static final Gson GSON = new GsonBuilder().create();

    private ItemStackUtil() {
    }

    public static Triple<ResourceLocation, Integer, CompoundTag> parseItemStackString(String res) {
        String[] tokens;
        String nbt = "";
        int nbtStart = res.indexOf("{");
        if (nbtStart > 0) {
            nbt = res.substring(nbtStart).replaceAll("([^\\\\])'", "$1\"").replaceAll("\\\\'", "'");
            res = res.substring(0, nbtStart);
        }
        String[] upper = res.split("#");
        String count = "1";
        if (upper.length > 1) {
            res = upper[0];
            count = upper[1];
        }
        if ((tokens = res.split(":")).length < 2) {
            throw new RuntimeException("Malformed item ID " + res);
        }
        ResourceLocation key = new ResourceLocation(tokens[0], tokens[1]);
        int countn = Integer.parseInt(count);
        CompoundTag tag = null;
        if (!nbt.isEmpty()) {
            try {
                tag = TagParser.m_129359_((String)nbt);
            }
            catch (CommandSyntaxException e) {
                throw new RuntimeException("Failed to parse ItemStack JSON", e);
            }
        }
        return ImmutableTriple.of((Object)key, (Object)countn, (Object)tag);
    }

    public static ItemStack loadFromParsed(Triple<ResourceLocation, Integer, CompoundTag> parsed) {
        ResourceLocation key = (ResourceLocation)parsed.getLeft();
        Integer count = (Integer)parsed.getMiddle();
        CompoundTag nbt = (CompoundTag)parsed.getRight();
        Optional maybeItem = BuiltInRegistries.f_257033_.m_6612_(key);
        if (maybeItem.isEmpty()) {
            throw new RuntimeException("Unknown item ID: " + String.valueOf(key));
        }
        Item item = (Item)maybeItem.get();
        ItemStack stack = new ItemStack((ItemLike)item, count.intValue());
        if (nbt != null) {
            stack.m_41751_(nbt);
        }
        return stack;
    }

    public static ItemStack loadStackFromString(String res) {
        return ItemStackUtil.loadFromParsed(ItemStackUtil.parseItemStackString(res));
    }

    public static Ingredient loadIngredientFromString(String ingredientString) {
        return Ingredient.m_43927_((ItemStack[])ItemStackUtil.loadStackListFromString(ingredientString).toArray(new ItemStack[0]));
    }

    public static List<ItemStack> loadStackListFromString(String ingredientString) {
        String[] stacksSerialized = ItemStackUtil.splitStacksFromSerializedIngredient(ingredientString);
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (String s : stacksSerialized) {
            if (s.startsWith("tag:")) {
                TagKey key = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)new ResourceLocation(s.substring(4)));
                BuiltInRegistries.f_257033_.m_203431_(key).ifPresent(tag -> tag.m_203614_().forEach(item -> stacks.add(new ItemStack(item))));
                continue;
            }
            stacks.add(ItemStackUtil.loadStackFromString(s));
        }
        return stacks;
    }

    public static StackWrapper wrapStack(ItemStack stack) {
        return stack.m_41619_() ? StackWrapper.EMPTY_WRAPPER : new StackWrapper(stack);
    }

    @Nullable
    public static Book getBookFromStack(ItemStack stack) {
        if (stack.m_41720_() instanceof ItemModBook) {
            return ItemModBook.getBook(stack);
        }
        Collection<Book> books = BookRegistry.INSTANCE.books.values();
        for (Book b : books) {
            if (!ItemStack.m_41656_((ItemStack)b.getBookItem(), (ItemStack)stack)) continue;
            return b;
        }
        return null;
    }

    private static String[] splitStacksFromSerializedIngredient(String ingredientSerialized) {
        ArrayList<String> result = new ArrayList<String>();
        int lastIndex = 0;
        int braces = 0;
        Character insideString = null;
        block7: for (int i = 0; i < ingredientSerialized.length(); ++i) {
            switch (ingredientSerialized.charAt(i)) {
                case '{': {
                    if (insideString != null) continue block7;
                    ++braces;
                    continue block7;
                }
                case '}': {
                    if (insideString != null) continue block7;
                    --braces;
                    continue block7;
                }
                case '\'': {
                    insideString = insideString == null ? Character.valueOf('\'') : null;
                    continue block7;
                }
                case '\"': {
                    insideString = insideString == null ? Character.valueOf('\"') : null;
                    continue block7;
                }
                case ',': {
                    if (braces > 0) continue block7;
                    result.add(ingredientSerialized.substring(lastIndex, i));
                    lastIndex = i + 1;
                }
            }
        }
        result.add(ingredientSerialized.substring(lastIndex));
        return result.toArray(new String[0]);
    }

    public static ItemStack loadStackFromJson(JsonObject json) {
        String itemName = json.get("item").getAsString();
        Item item = (Item)BuiltInRegistries.f_257033_.m_6612_(new ResourceLocation(itemName)).orElseThrow(() -> new IllegalArgumentException("Unknown item '" + itemName + "'"));
        ItemStack stack = new ItemStack((ItemLike)item, GsonHelper.m_13824_((JsonObject)json, (String)"count", (int)1));
        if (json.has("nbt")) {
            try {
                JsonElement element = json.get("nbt");
                CompoundTag nbt = element.isJsonObject() ? TagParser.m_129359_((String)GSON.toJson(element)) : TagParser.m_129359_((String)element.getAsString());
                stack.m_41751_(nbt);
            }
            catch (CommandSyntaxException e) {
                throw new IllegalArgumentException("Invalid NBT Entry: " + String.valueOf((Object)e), e);
            }
        }
        return stack;
    }

    public static class StackWrapper {
        public static final StackWrapper EMPTY_WRAPPER = new StackWrapper(ItemStack.f_41583_);
        public final ItemStack stack;

        public StackWrapper(ItemStack stack) {
            this.stack = stack;
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof StackWrapper && ItemStack.m_41656_((ItemStack)this.stack, (ItemStack)((StackWrapper)obj).stack);
        }

        public int hashCode() {
            return this.stack.m_41720_().hashCode();
        }

        public String toString() {
            return "Wrapper[" + this.stack.toString() + "]";
        }
    }
}

