/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import mcjty.lostcities.LostCities;
import mcjty.lostcities.config.LandscapeType;
import mcjty.lostcities.config.LostCityProfile;
import mcjty.lostcities.config.LostCityProfileSetupImp;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.commons.io.FileUtils;

public class ProfileSetup {
    public static final Map<String, LostCityProfile> STANDARD_PROFILES = new HashMap<String, LostCityProfile>();

    private static void initStandardProfiles() {
        LostCityProfile profile = new LostCityProfile("default", true);
        profile.setIconFile("textures/gui/icon_default.png");
        STANDARD_PROFILES.put(profile.getName(), profile);
        profile = new LostCityProfile("cavern", true);
        profile.setDescription("This profile is meant for a cavern type world. There are lights in the building but the outside is very dark.");
        profile.setExtraDescription("This is very hard. It's recommended you enable a bonus chest!");
        profile.setWarning("Use this in combination with the Lost Worlds 'caves' world type");
        profile.setIconFile("textures/gui/icon_cavern.png");
        profile.LANDSCAPE_TYPE = LandscapeType.CAVERN;
        profile.HORIZON = 128.0f;
        profile.FOG_RED = 0.0f;
        profile.FOG_GREEN = 0.0f;
        profile.FOG_BLUE = 0.0f;
        profile.FOG_DENSITY = 0.02f;
        profile.EXPLOSION_CHANCE = 0.0f;
        profile.MINI_EXPLOSION_CHANCE = 0.0f;
        profile.GENERATE_LIGHTING = true;
        profile.RAILWAYS_ENABLED = false;
        profile.GROUNDLEVEL = 40;
        profile.SEALEVEL = 32;
        profile.CITY_LEVEL0_HEIGHT = 44;
        profile.CITY_LEVEL1_HEIGHT = 52;
        profile.CITY_LEVEL2_HEIGHT = 60;
        profile.CITY_LEVEL3_HEIGHT = 68;
        profile.CITY_LEVEL4_HEIGHT = 76;
        profile.CITY_LEVEL5_HEIGHT = 82;
        profile.CITY_LEVEL6_HEIGHT = 90;
        profile.CITY_LEVEL7_HEIGHT = 98;
        STANDARD_PROFILES.put(profile.getName(), profile);
        profile = new LostCityProfile("nodamage", true);
        profile.setDescription("Like default but no explosion damage");
        profile.setExtraDescription("Ruins and rubble are disabled and ravines are disabled in cities");
        profile.setIconFile("textures/gui/icon_nodamage.png");
        profile.EXPLOSION_CHANCE = 0.0f;
        profile.MINI_EXPLOSION_CHANCE = 0.0f;
        profile.RUIN_CHANCE = 0.0f;
        profile.RUBBLELAYER = false;
        STANDARD_PROFILES.put(profile.getName(), profile);
        profile = new LostCityProfile("floating", true);
        profile.setDescription("Cities on floating islands");
        profile.setExtraDescription("Note! No mineshafts or strongholds in this profile!");
        profile.setWarning("Preferably use this in combination with the Lost Worlds 'islands' world type");
        profile.setIconFile("textures/gui/icon_floating.png");
        profile.CITY_CHANCE = 0.03f;
        profile.LANDSCAPE_TYPE = LandscapeType.FLOATING;
        profile.HORIZON = 0.0f;
        profile.HIGHWAY_SUPPORTS = false;
        profile.BUILDING_MAXCELLARS = 1;
        profile.RAILWAYS_CAN_END = true;
        profile.RAILWAYS_ENABLED = false;
        profile.RAILWAY_STATIONS_ENABLED = false;
        profile.HIGHWAY_DISTANCE_MASK = 15;
        profile.GROUNDLEVEL = 50;
        profile.CITY_LEVEL0_HEIGHT = 50;
        profile.CITY_LEVEL1_HEIGHT = 56;
        profile.CITY_LEVEL2_HEIGHT = 62;
        profile.CITY_LEVEL3_HEIGHT = 68;
        profile.CITY_LEVEL4_HEIGHT = 76;
        profile.CITY_LEVEL5_HEIGHT = 84;
        profile.CITY_LEVEL6_HEIGHT = 92;
        profile.CITY_LEVEL7_HEIGHT = 100;
        STANDARD_PROFILES.put(profile.getName(), profile);
        profile = new LostCityProfile("space", true);
        profile.setDescription("Cities in floating glass bubbles");
        profile.setExtraDescription("Note! No villages, mineshafts or strongholds in this profile!");
        profile.setWarning("Preferably use this in combination with the Lost Worlds 'spheres' world type");
        profile.setIconFile("textures/gui/icon_space.png");
        profile.LANDSCAPE_TYPE = LandscapeType.SPACE;
        profile.CITYSPHERE_OUTSIDE_PROFILE = "void_outside";
        profile.SPAWN_SPHERE = "<in>";
        profile.HORIZON = 0.0f;
        profile.CITYSPHERE_CHANCE = 0.9f;
        profile.CITYSPHERE_CLEARABOVE = 8;
        profile.CITYSPHERE_CLEARABOVE_UNTIL_AIR = true;
        profile.CITYSPHERE_CLEARBELOW = 8;
        profile.CITYSPHERE_CLEARBELOW_UNTIL_AIR = true;
        profile.RAILWAYS_CAN_END = true;
        profile.RAILWAYS_ENABLED = false;
        profile.RAILWAY_STATIONS_ENABLED = false;
        profile.HIGHWAY_DISTANCE_MASK = 0;
        profile.BRIDGE_SUPPORTS = false;
        profile.HIGHWAY_SUPPORTS = false;
        profile.RUBBLELAYER = false;
        profile.GROUNDLEVEL = 71;
        profile.EXPLOSION_CHANCE = 1.0E-4f;
        profile.MINI_EXPLOSION_CHANCE = 0.001f;
        profile.CITY_CHANCE = 0.7f;
        profile.CITY_MAXRADIUS = 90;
        profile.CITY_THRESHOLD = 0.05f;
        profile.CITY_LEVEL0_HEIGHT = 60;
        profile.CITY_LEVEL1_HEIGHT = 66;
        profile.CITY_LEVEL2_HEIGHT = 72;
        profile.CITY_LEVEL3_HEIGHT = 78;
        profile.CITY_LEVEL4_HEIGHT = 86;
        profile.CITY_LEVEL5_HEIGHT = 94;
        profile.CITY_LEVEL6_HEIGHT = 100;
        profile.CITY_LEVEL7_HEIGHT = 108;
        profile.BUILDING_CHANCE = 0.3f;
        profile.GENERATE_LIGHTING = true;
        STANDARD_PROFILES.put(profile.getName(), profile);
        profile = new LostCityProfile("biosphere_caves", false);
        profile.setDescription("Spheres in large caverns");
        profile.setWarning("Use this in combination with the Lost Worlds 'cavespheres' world type");
        profile.setIconFile("textures/gui/icon_cavespheres.png");
        profile.LANDSCAPE_TYPE = LandscapeType.CAVERNSPHERES;
        profile.HORIZON = 30.0f;
        profile.CITYSPHERE_MONORAIL_CHANCE = 0.0f;
        profile.CITYSPHERE_OUTSIDE_PROFILE = "cavern";
        profile.CITYSPHERE_OUTSIDE_SURFACE_VARIATION = 0.5f;
        profile.SPAWN_SPHERE = "<in>";
        profile.EXPLOSION_CHANCE = 0.0f;
        profile.MINI_EXPLOSION_CHANCE = 0.01f;
        profile.MINI_EXPLOSION_MINHEIGHT = 60;
        profile.MINI_EXPLOSION_MAXHEIGHT = 75;
        profile.MINI_EXPLOSION_MINRADIUS = 5;
        profile.MINI_EXPLOSION_MAXRADIUS = 10;
        profile.RAILWAYS_CAN_END = true;
        profile.RAILWAYS_ENABLED = false;
        profile.RAILWAY_STATIONS_ENABLED = false;
        profile.HIGHWAY_DISTANCE_MASK = 0;
        profile.RUIN_CHANCE = 0.7f;
        profile.RUIN_MINLEVEL_PERCENT = 0.3f;
        profile.RUIN_MAXLEVEL_PERCENT = 0.8f;
        profile.RUBBLELAYER = false;
        profile.CITYSPHERE_CHANCE = 0.5f;
        profile.CITYSPHERE_CLEARABOVE = 30;
        profile.CITY_CHANCE = 0.9f;
        profile.CITY_MINRADIUS = 50;
        profile.CITY_MAXRADIUS = 65;
        profile.CITY_THRESHOLD = 0.05f;
        profile.CITY_LEVEL0_HEIGHT = 60;
        profile.CITY_LEVEL1_HEIGHT = 66;
        profile.CITY_LEVEL2_HEIGHT = 72;
        profile.CITY_LEVEL3_HEIGHT = 78;
        profile.CITY_LEVEL4_HEIGHT = 86;
        profile.CITY_LEVEL5_HEIGHT = 94;
        profile.CITY_LEVEL6_HEIGHT = 100;
        profile.CITY_LEVEL7_HEIGHT = 108;
        profile.BUILDING_CHANCE = 0.3f;
        profile.GENERATE_LIGHTING = true;
        STANDARD_PROFILES.put(profile.getName(), profile);
        profile = new LostCityProfile("biosphere", true);
        profile.setDescription("Jungles in big glass bubbles on a barren landscape");
        profile.setWarning("Preferably use this in combination with the Lost Worlds 'normal' world type");
        profile.setIconFile("textures/gui/icon_biosphere.png");
        profile.LANDSCAPE_TYPE = LandscapeType.SPHERES;
        profile.HORIZON = 30.0f;
        profile.CITYSPHERE_MONORAIL_CHANCE = 0.0f;
        profile.CITYSPHERE_OUTSIDE_PROFILE = "bio_wasteland";
        profile.CITYSPHERE_OUTSIDE_SURFACE_VARIATION = 0.5f;
        profile.SPAWN_SPHERE = "<in>";
        profile.EXPLOSION_CHANCE = 0.0f;
        profile.MINI_EXPLOSION_CHANCE = 0.01f;
        profile.MINI_EXPLOSION_MINHEIGHT = 60;
        profile.MINI_EXPLOSION_MAXHEIGHT = 75;
        profile.MINI_EXPLOSION_MINRADIUS = 5;
        profile.MINI_EXPLOSION_MAXRADIUS = 10;
        profile.RAILWAYS_CAN_END = true;
        profile.RAILWAYS_ENABLED = false;
        profile.RAILWAY_STATIONS_ENABLED = false;
        profile.HIGHWAY_DISTANCE_MASK = 0;
        profile.RUIN_CHANCE = 0.7f;
        profile.RUIN_MINLEVEL_PERCENT = 0.3f;
        profile.RUIN_MAXLEVEL_PERCENT = 0.8f;
        profile.RUBBLELAYER = false;
        profile.CITYSPHERE_CHANCE = 0.5f;
        profile.CITYSPHERE_CLEARABOVE = 30;
        profile.CITY_CHANCE = 0.8f;
        profile.CITY_MINRADIUS = 50;
        profile.CITY_MAXRADIUS = 65;
        profile.CITY_THRESHOLD = 0.05f;
        profile.CITY_LEVEL0_HEIGHT = 60;
        profile.CITY_LEVEL1_HEIGHT = 66;
        profile.CITY_LEVEL2_HEIGHT = 72;
        profile.CITY_LEVEL3_HEIGHT = 78;
        profile.CITY_LEVEL4_HEIGHT = 86;
        profile.CITY_LEVEL5_HEIGHT = 94;
        profile.CITY_LEVEL6_HEIGHT = 100;
        profile.CITY_LEVEL7_HEIGHT = 108;
        profile.BUILDING_CHANCE = 0.3f;
        profile.GENERATE_LIGHTING = true;
        STANDARD_PROFILES.put(profile.getName(), profile);
        profile = new LostCityProfile("rarecities", true);
        profile.setDescription("Cities are rare");
        profile.setIconFile("textures/gui/icon_rarecities.png");
        profile.CITY_CHANCE = 0.001;
        profile.RUIN_CHANCE = 0.0f;
        profile.HIGHWAY_REQUIRES_TWO_CITIES = false;
        profile.RAILWAYS_CAN_END = true;
        STANDARD_PROFILES.put(profile.getName(), profile);
        profile = new LostCityProfile("onlycities", true);
        profile.setDescription("The entire world is a city");
        profile.setIconFile("textures/gui/icon_onlycities.png");
        profile.CITY_CHANCE = 0.2;
        profile.CITY_MAXRADIUS = 256;
        STANDARD_PROFILES.put(profile.getName(), profile);
        profile = new LostCityProfile("tallbuildings", true);
        profile.setDescription("Very tall buildings (performance heavy)");
        profile.setIconFile("textures/gui/icon_tallbuildings.png");
        profile.BUILDING_MINFLOORS = 4;
        profile.BUILDING_MINFLOORS_CHANCE = 8;
        profile.BUILDING_MAXFLOORS_CHANCE = 15;
        profile.BUILDING_MAXFLOORS = 19;
        profile.DEBRIS_TO_NEARBYCHUNK_FACTOR = 175;
        profile.EXPLOSION_CHANCE = 0.006f;
        profile.EXPLOSION_MAXHEIGHT = 256;
        profile.EXPLOSION_MAXRADIUS = 60;
        profile.EXPLOSION_MINHEIGHT = 130;
        profile.MINI_EXPLOSION_CHANCE = 0.09f;
        profile.MINI_EXPLOSION_MAXHEIGHT = 256;
        profile.MINI_EXPLOSION_MAXRADIUS = 14;
        profile.MINI_EXPLOSION_MINRADIUS = 3;
        profile.RUIN_CHANCE = 0.01f;
        STANDARD_PROFILES.put(profile.getName(), profile);
        profile = new LostCityProfile("safe", true);
        profile.setDescription("Safe mode: no spawners, lighting but no loot");
        profile.setIconFile("textures/gui/icon_safe.png");
        profile.GENERATE_SPAWNERS = false;
        profile.GENERATE_LIGHTING = true;
        profile.GENERATE_LOOT = false;
        STANDARD_PROFILES.put(profile.getName(), profile);
        profile = new LostCityProfile("ancient", true);
        profile.setDescription("Ancient jungle city, vines and leafs, ruined buildings");
        profile.setIconFile("textures/gui/icon_ancient.png");
        profile.THICKNESS_OF_RANDOM_LEAFBLOCKS = 6;
        profile.CHANCE_OF_RANDOM_LEAFBLOCKS = 0.05f;
        profile.VINE_CHANCE = 0.1f;
        profile.EXPLOSION_CHANCE = 0.0f;
        profile.MINI_EXPLOSION_CHANCE = 0.0f;
        profile.RUBBLELAYER = true;
        profile.RUBBLE_DIRT_SCALE = 2.0f;
        profile.RUBBLE_LEAVE_SCALE = 2.0f;
        profile.RUIN_CHANCE = 0.9f;
        profile.RUIN_MINLEVEL_PERCENT = 0.0f;
        profile.RUIN_MAXLEVEL_PERCENT = 0.9f;
        STANDARD_PROFILES.put(profile.getName(), profile);
        profile = new LostCityProfile("wasteland", true);
        profile.setDescription("Wasteland, no water, bare land");
        profile.setExtraDescription("This profile works best with Biomes O Plenty and the Wastify mod");
        profile.setIconFile("textures/gui/icon_wasteland.png");
        profile.VINE_CHANCE = 0.003f;
        profile.CHANCE_OF_RANDOM_LEAFBLOCKS = 0.01f;
        profile.RUBBLELAYER = true;
        profile.RUBBLE_DIRT_SCALE = 2.0f;
        profile.RUBBLE_LEAVE_SCALE = 0.0f;
        profile.RUIN_CHANCE = 0.5f;
        profile.RUIN_MINLEVEL_PERCENT = 0.5f;
        profile.RUIN_MAXLEVEL_PERCENT = 0.9f;
        profile.AVOID_WATER = true;
        profile.AVOID_FOLIAGE = true;
        STANDARD_PROFILES.put(profile.getName(), profile);
        profile = new LostCityProfile("atlantis", true);
        profile.setDescription("Drowned cities, raised waterlevel (to 89)");
        profile.setWarning("Preferably use this in combination with the Lost Worlds 'atlantis' world type");
        profile.setIconFile("textures/gui/icon_atlantis.png");
        profile.SEALEVEL = 89;
        profile.RUIN_CHANCE = 0.1f;
        STANDARD_PROFILES.put(profile.getName(), profile);
        profile = new LostCityProfile("bio_wasteland", false);
        profile.setDescription("Private wasteland for biospheres");
        profile.GROUNDLEVEL = 71;
        profile.AVOID_WATER = true;
        profile.CITY_CHANCE = 0.008f;
        profile.CITY_MINRADIUS = 30;
        profile.CITY_MAXRADIUS = 80;
        profile.VINE_CHANCE = 0.0f;
        profile.CHANCE_OF_RANDOM_LEAFBLOCKS = 0.0f;
        profile.RUBBLELAYER = true;
        profile.RUBBLE_DIRT_SCALE = 2.0f;
        profile.RUBBLE_LEAVE_SCALE = 0.0f;
        profile.BUILDING_MAXCELLARS = 1;
        profile.RUIN_CHANCE = 1.0f;
        profile.RUIN_MINLEVEL_PERCENT = 0.1f;
        profile.RUIN_MAXLEVEL_PERCENT = 0.4f;
        profile.AVOID_FOLIAGE = true;
        STANDARD_PROFILES.put(profile.getName(), profile);
        profile = new LostCityProfile("void_outside", false);
        profile.setDescription("Private wasteland for space");
        profile.GROUNDLEVEL = 71;
        profile.AVOID_WATER = true;
        profile.CITY_CHANCE = 0.0;
        profile.CITY_MINRADIUS = 30;
        profile.CITY_MAXRADIUS = 80;
        profile.VINE_CHANCE = 0.0f;
        profile.RAILWAY_STATIONS_ENABLED = false;
        profile.RAILWAYS_ENABLED = false;
        profile.HIGHWAY_DISTANCE_MASK = 0;
        profile.BRIDGE_SUPPORTS = false;
        profile.HIGHWAY_SUPPORTS = false;
        profile.CHANCE_OF_RANDOM_LEAFBLOCKS = 0.0f;
        profile.RUBBLELAYER = true;
        profile.RUBBLE_DIRT_SCALE = 2.0f;
        profile.RUBBLE_LEAVE_SCALE = 0.0f;
        profile.BUILDING_MAXCELLARS = 1;
        profile.RUIN_CHANCE = 1.0f;
        profile.RUIN_MINLEVEL_PERCENT = 0.1f;
        profile.RUIN_MAXLEVEL_PERCENT = 0.4f;
        profile.AVOID_FOLIAGE = true;
        STANDARD_PROFILES.put(profile.getName(), profile);
        profile = new LostCityProfile("largecities", true);
        profile.setIconFile("textures/gui/icon_default.png");
        profile.CITY_CHANCE = -1.0;
        profile.CITY_PERLIN_SCALE = 7.0;
        profile.CITY_PERLIN_OFFSET = 0.2;
        profile.CITY_PERLIN_INNERSCALE = 0.1;
        profile.CITY_THRESHOLD = 0.1f;
        profile.CITY_STYLE_THRESHOLD = 0.4f;
        profile.CITY_STYLE_ALTERNATIVE = "citystyle_border";
        profile.GENERATE_LIGHTING = true;
        profile.BUILDING_MAXFLOORS = 9;
        profile.BUILDING_MAXFLOORS_CHANCE = 7;
        profile.BUILDING_CHANCE = 0.4f;
        STANDARD_PROFILES.put(profile.getName(), profile);
    }

    public static void setupProfiles() {
        Path path = FMLPaths.CONFIGDIR.get();
        Path profileDir = Paths.get(path.toString(), "lostcities/profiles");
        LostCities.getLogger().info("Creating standard profiles into 'config/lostcities/profiles'");
        ProfileSetup.initStandardProfiles();
        LostCityProfileSetupImp setupImp = new LostCityProfileSetupImp();
        LostCities.setup.profileSetups.forEach(consumer -> consumer.accept(setupImp));
        new File(profileDir.toString()).mkdirs();
        for (Map.Entry<String, LostCityProfile> entry : STANDARD_PROFILES.entrySet()) {
            String name = entry.getKey();
            if ("customized".equals(name)) continue;
            LostCityProfile profile = entry.getValue();
            JsonObject jsonObject = profile.toJson(true);
            Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
            try (PrintWriter writer = new PrintWriter(new File(profileDir.toString(), name + ".json"));){
                writer.print(gson.toJson((JsonElement)jsonObject));
                writer.flush();
            }
            catch (FileNotFoundException e) {
                LostCities.getLogger().error("Couldn't save profile '{}'!", (Object)name);
            }
        }
        LostCities.getLogger().info("Reading existing profiles from 'config/lostcities/profiles'");
        ProfileSetup.readProfiles(profileDir);
    }

    private static void readProfiles(Path profileDir) {
        File[] files;
        for (File file : files = new File(profileDir.toString()).listFiles((dir, name) -> name.endsWith(".json"))) {
            String name2 = file.getName();
            try {
                String json = FileUtils.readFileToString((File)file, (String)"UTF-8");
                String[] split = name2.split("\\.");
                LostCityProfile profile = new LostCityProfile(split[0], json);
                STANDARD_PROFILES.put(split[0], profile);
            }
            catch (IOException e) {
                LostCities.getLogger().error("Couldn't read profile '{}'!", (Object)name2);
                return;
            }
        }
    }
}

