/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.editor;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.state.BlockState;

public class EditorInfo {
    private final String partName;
    private final BlockPos bottomLocation;
    private final Map<BlockState, Character> reversedPalette = new HashMap<BlockState, Character>();
    private static final Map<UUID, EditorInfo> EDITING = new HashMap<UUID, EditorInfo>();

    public EditorInfo(String partName, BlockPos bottomLocation) {
        this.partName = partName;
        this.bottomLocation = bottomLocation;
    }

    public void addPaletteEntry(char c, BlockState state) {
        this.reversedPalette.put(state, Character.valueOf(c));
    }

    public String getPartName() {
        return this.partName;
    }

    public BlockPos getBottomLocation() {
        return this.bottomLocation;
    }

    public Character getPaleteEntry(BlockState state) {
        return this.reversedPalette.get(state);
    }

    public static EditorInfo getEditorInfo(UUID uuid) {
        return EDITING.get(uuid);
    }

    public static EditorInfo createEditorInfo(UUID uuid, String partName, BlockPos bottomLocation) {
        EditorInfo info = new EditorInfo(partName, bottomLocation);
        EDITING.put(uuid, info);
        return info;
    }
}

