/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.worldgen.lost.regassets.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import mcjty.lostcities.worldgen.lost.regassets.data.BlockEntry;
import net.minecraft.nbt.CompoundTag;

public class PaletteEntry {
    public static final Codec<PaletteEntry> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("char").forGetter(PaletteEntry::getChr), (App)Codec.STRING.optionalFieldOf("block").forGetter(l -> Optional.ofNullable(l.getBlock())), (App)Codec.STRING.optionalFieldOf("variant").forGetter(l -> Optional.ofNullable(l.getVariant())), (App)Codec.STRING.optionalFieldOf("frompalette").forGetter(l -> Optional.ofNullable(l.getFrompalette())), (App)Codec.list(BlockEntry.CODEC).optionalFieldOf("blocks").forGetter(l -> Optional.ofNullable(l.getBlocks())), (App)Codec.STRING.optionalFieldOf("damaged").forGetter(l -> Optional.ofNullable(l.getDamaged())), (App)Codec.STRING.optionalFieldOf("mob").forGetter(l -> Optional.ofNullable(l.getMob())), (App)Codec.STRING.optionalFieldOf("loot").forGetter(l -> Optional.ofNullable(l.getLoot())), (App)Codec.BOOL.optionalFieldOf("torch").forGetter(l -> Optional.ofNullable(l.getTorch())), (App)CompoundTag.f_128325_.optionalFieldOf("tag").forGetter(l -> Optional.ofNullable(l.getTag()))).apply((Applicative)instance, PaletteEntry::new));
    private String chr;
    private String block;
    private String variant;
    private String frompalette;
    private List<BlockEntry> blocks;
    private String damaged;
    private String mob;
    private String loot;
    private Boolean torch;
    private CompoundTag tag;

    public PaletteEntry() {
    }

    public static PaletteEntry block(String block) {
        PaletteEntry entry = new PaletteEntry();
        entry.block = block;
        return entry;
    }

    public static PaletteEntry variant(String variant) {
        PaletteEntry entry = new PaletteEntry();
        entry.variant = variant;
        return entry;
    }

    public static PaletteEntry frompalette(String frompalette) {
        PaletteEntry entry = new PaletteEntry();
        entry.frompalette = frompalette;
        return entry;
    }

    public static PaletteEntry blocks(List<BlockEntry> blocks) {
        PaletteEntry entry = new PaletteEntry();
        entry.blocks = blocks;
        return entry;
    }

    public String getChr() {
        return this.chr;
    }

    public String getBlock() {
        return this.block;
    }

    public String getVariant() {
        return this.variant;
    }

    public String getFrompalette() {
        return this.frompalette;
    }

    public List<BlockEntry> getBlocks() {
        return this.blocks;
    }

    public String getDamaged() {
        return this.damaged;
    }

    public String getMob() {
        return this.mob;
    }

    public String getLoot() {
        return this.loot;
    }

    public Boolean getTorch() {
        return this.torch;
    }

    public CompoundTag getTag() {
        return this.tag;
    }

    public PaletteEntry(String chr, Optional<String> block, Optional<String> variant, Optional<String> frompalette, Optional<List<BlockEntry>> blocks, Optional<String> damaged, Optional<String> mob, Optional<String> loot, Optional<Boolean> torch, Optional<CompoundTag> tag) {
        this.chr = chr;
        this.block = block.orElse(null);
        this.variant = variant.orElse(null);
        this.frompalette = frompalette.orElse(null);
        this.blocks = blocks.orElse(null);
        this.damaged = damaged.orElse(null);
        this.mob = mob.orElse(null);
        this.loot = loot.orElse(null);
        this.torch = torch.orElse(null);
        this.tag = tag.orElse(null);
    }

    public String toString() {
        return "PaletteEntry{chr='" + this.chr + "', block='" + this.block + "', variant='" + this.variant + "', frompalette='" + this.frompalette + "', blocks=" + String.valueOf(this.blocks) + ", damaged='" + this.damaged + "', mob='" + this.mob + "', loot='" + this.loot + "', torch=" + this.torch + ", tag=" + String.valueOf(this.tag) + "}";
    }
}

