/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.pocket;

import dan200.computercraft.client.pocket.PocketComputerData;
import dan200.computercraft.shared.computer.core.ComputerState;
import dan200.computercraft.shared.computer.terminal.TerminalState;
import dan200.computercraft.shared.pocket.items.PocketComputerItem;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.world.item.ItemStack;
import org.jspecify.annotations.Nullable;

public final class ClientPocketComputers {
    private static final Map<UUID, PocketComputerData> instances = new HashMap<UUID, PocketComputerData>();

    private ClientPocketComputers() {
    }

    public static void reset() {
        instances.clear();
    }

    public static void remove(UUID id) {
        instances.remove(id);
    }

    public static void setState(UUID instanceId, ComputerState state, int lightColour, @Nullable TerminalState terminalData) {
        PocketComputerData computer = instances.get(instanceId);
        if (computer == null) {
            instances.put(instanceId, new PocketComputerData(state, lightColour, terminalData));
        } else {
            computer.setState(state, lightColour, terminalData);
        }
    }

    public static @Nullable PocketComputerData get(ItemStack stack) {
        UUID id = PocketComputerItem.getInstanceID(stack);
        return id == null ? null : instances.get(id);
    }
}

