/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.inventory;

import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.shared.ModRegistry;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.core.ServerComputer;
import dan200.computercraft.shared.computer.inventory.AbstractComputerMenu;
import dan200.computercraft.shared.network.container.ComputerContainerData;
import dan200.computercraft.shared.turtle.core.TurtleBrain;
import dan200.computercraft.shared.turtle.inventory.UpgradeContainer;
import dan200.computercraft.shared.turtle.inventory.UpgradeSlot;
import java.util.function.Predicate;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jspecify.annotations.Nullable;

public final class TurtleMenu
extends AbstractComputerMenu {
    public static final int BORDER = 8;
    public static final int PLAYER_START_Y = 134;
    public static final int TURTLE_START_X = 192;
    public static final int PLAYER_START_X = 25;
    public static final int UPGRADE_START_X = 271;
    private final ContainerData data;

    private TurtleMenu(int id, Predicate<Player> canUse, ComputerFamily family, @Nullable ServerComputer computer, @Nullable ComputerContainerData menuData, Inventory playerInventory, Container inventory, Container turtleUpgrades, ContainerData data) {
        super((MenuType<? extends AbstractComputerMenu>)((MenuType)ModRegistry.Menus.TURTLE.get()), id, canUse, family, computer, menuData);
        int x;
        int y;
        this.data = data;
        this.m_38884_(data);
        for (y = 0; y < 4; ++y) {
            for (x = 0; x < 4; ++x) {
                this.m_38897_(new Slot(inventory, x + y * 4, 193 + x * 18, 135 + y * 18));
            }
        }
        for (y = 0; y < 3; ++y) {
            for (x = 0; x < 9; ++x) {
                this.m_38897_(new Slot((Container)playerInventory, x + y * 9 + 9, 25 + x * 18, 135 + y * 18));
            }
        }
        for (int x2 = 0; x2 < 9; ++x2) {
            this.m_38897_(new Slot((Container)playerInventory, x2, 25 + x2 * 18, 193));
        }
        this.m_38897_(new UpgradeSlot(turtleUpgrades, TurtleSide.LEFT, 0, 271, 135));
        this.m_38897_(new UpgradeSlot(turtleUpgrades, TurtleSide.RIGHT, 1, 271, 153));
    }

    public static TurtleMenu ofBrain(int id, Inventory player, TurtleBrain turtle) {
        return new TurtleMenu(id, p -> turtle.getOwner().m_6542_((Player)p), turtle.getFamily(), turtle.getOwner().createServerComputer(), null, player, turtle.getInventory(), new UpgradeContainer(turtle), turtle::getSelectedSlot);
    }

    public static TurtleMenu ofMenuData(int id, Inventory player, ComputerContainerData data) {
        return new TurtleMenu(id, x -> true, data.family(), null, data, player, (Container)new SimpleContainer(16), (Container)new SimpleContainer(2), (ContainerData)new SimpleContainerData(1));
    }

    public int getSelectedSlot() {
        return this.data.m_6413_(0);
    }

    private ItemStack tryItemMerge(Player player, int slotNum, int firstSlot, int lastSlot, boolean reverse) {
        Slot slot = (Slot)this.f_38839_.get(slotNum);
        ItemStack originalStack = ItemStack.f_41583_;
        if (slot != null && slot.m_6657_()) {
            ItemStack clickedStack = slot.m_7993_();
            originalStack = clickedStack.m_41777_();
            if (!this.m_38903_(clickedStack, firstSlot, lastSlot, reverse)) {
                return ItemStack.f_41583_;
            }
            if (clickedStack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (clickedStack.m_41613_() != originalStack.m_41613_()) {
                slot.m_142406_(player, clickedStack);
            } else {
                return ItemStack.f_41583_;
            }
        }
        return originalStack;
    }

    public ItemStack m_7648_(Player player, int slotNum) {
        if (slotNum >= 0 && slotNum < 16) {
            return this.tryItemMerge(player, slotNum, 16, 52, true);
        }
        if (slotNum >= 16) {
            return this.tryItemMerge(player, slotNum, 0, 16, false);
        }
        return ItemStack.f_41583_;
    }
}

