/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.upgrades;

import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.turtle.AbstractTurtleUpgrade;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.TurtleCommandResult;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.api.turtle.TurtleUpgradeType;
import dan200.computercraft.api.turtle.TurtleVerb;
import dan200.computercraft.shared.peripheral.modem.ModemState;
import dan200.computercraft.shared.peripheral.modem.wireless.WirelessModemPeripheral;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jspecify.annotations.Nullable;

public class TurtleModem
extends AbstractTurtleUpgrade {
    private final boolean advanced;

    public TurtleModem(ResourceLocation id, ItemStack stack, boolean advanced) {
        super(id, TurtleUpgradeType.PERIPHERAL, advanced ? "upgrade.computercraft.wireless_modem_advanced.adjective" : "upgrade.computercraft.wireless_modem_normal.adjective", stack);
        this.advanced = advanced;
    }

    @Override
    public IPeripheral createPeripheral(ITurtleAccess turtle, TurtleSide side) {
        return new Peripheral(turtle, this.advanced);
    }

    @Override
    public TurtleCommandResult useTool(ITurtleAccess turtle, TurtleSide side, TurtleVerb verb, Direction dir) {
        return TurtleCommandResult.failure();
    }

    @Override
    public void update(ITurtleAccess turtle, TurtleSide side) {
        Peripheral modem;
        ModemState state;
        IPeripheral peripheral;
        if (!turtle.getLevel().f_46443_ && (peripheral = turtle.getPeripheral(side)) instanceof Peripheral && (state = (modem = (Peripheral)peripheral).getModemState()).pollChanged()) {
            turtle.getUpgradeNBTData(side).m_128379_("active", state.isOpen());
            turtle.updateUpgradeNBTData(side);
        }
    }

    @Override
    public CompoundTag getPersistedData(CompoundTag upgradeData) {
        return new CompoundTag();
    }

    private static class Peripheral
    extends WirelessModemPeripheral {
        private final ITurtleAccess turtle;

        Peripheral(ITurtleAccess turtle, boolean advanced) {
            super(new ModemState(), advanced);
            this.turtle = turtle;
        }

        @Override
        public Level getLevel() {
            return this.turtle.getLevel();
        }

        @Override
        public Vec3 getPosition() {
            BlockPos turtlePos = this.turtle.getPosition();
            return new Vec3((double)turtlePos.m_123341_(), (double)turtlePos.m_123342_(), (double)turtlePos.m_123343_());
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(@Nullable IPeripheral other) {
            if (this == other) return true;
            if (!(other instanceof Peripheral)) return false;
            Peripheral modem = (Peripheral)other;
            if (modem.turtle != this.turtle) return false;
            return true;
        }
    }
}

