/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.util;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MessageUtils {
    private static MessageBuilder NOOP = new MessageBuilder((Component)Component.m_237113_((String)"")){

        @Override
        public void sendTo(Player ... players) {
        }

        @Override
        public void sendTo(Collection<Player> players) {
        }

        @Override
        public MessageBuilderColonyPlayerSelector sendTo(IColony colony) {
            return NOOPColony;
        }

        @Override
        public MessageBuilderColonyPlayerSelector sendTo(IColony colony, boolean alwaysShowColony) {
            return NOOPColony;
        }
    };
    private static MessageBuilderColonyPlayerSelector NOOPColony = new MessageBuilderColonyPlayerSelector(null, null, false){

        @Override
        public void forAllPlayers() {
        }

        @Override
        public void forManagers() {
        }
    };

    public static MessageBuilder forCitizen(AbstractEntityCitizen citizen, String keyIn, Object ... msg) {
        return MessageUtils.forCitizen(citizen, (Component)Component.m_237110_((String)keyIn, (Object[])msg));
    }

    public static MessageBuilder forCitizen(AbstractEntityCitizen citizen, Component component) {
        if (citizen.getCitizenColonyHandler().getColonyOrRegister() != null) {
            IJob<?> job = citizen.getCitizenJobHandler().getColonyJob();
            MessageBuilder builder = job != null ? MessageUtils.format(job.getJobRegistryEntry().getTranslationKey(), new Object[0]).append((Component)Component.m_237113_((String)" ")).append(citizen.m_7770_()).append((Component)Component.m_237113_((String)": ")).append(component) : MessageUtils.format(citizen.m_7770_()).append((Component)Component.m_237113_((String)": ")).append(component);
            return builder;
        }
        return NOOP;
    }

    public static MessageBuilder format(String key, Object ... args) {
        return MessageUtils.format((Component)Component.m_237110_((String)key, (Object[])args));
    }

    public static MessageBuilder format(Component component) {
        return new MessageBuilder(component);
    }

    public static class MessageBuilder {
        private final MutableComponent fullComponent;
        @NotNull
        private MessagePriority priority = MessagePriority.NORMAL;
        @Nullable
        private ClickEvent clickEvent;

        MessageBuilder(Component component) {
            this.fullComponent = this.getFormattableComponent(component);
        }

        @NotNull
        public MessageBuilder withPriority(MessagePriority priority) {
            this.priority = priority;
            return this;
        }

        public MessageBuilder withClickEvent(@NotNull ClickEvent clickEvent) {
            this.clickEvent = clickEvent;
            return this;
        }

        public MessageBuilder append(String key, Object ... args) {
            return this.append((Component)Component.m_237110_((String)key, (Object[])args));
        }

        public MessageBuilder append(Component component) {
            this.fullComponent.m_7220_((Component)this.getFormattableComponent(component));
            return this;
        }

        public MutableComponent create() {
            Style newStyle = Style.f_131099_.m_131140_(this.priority.color).m_131142_(this.clickEvent);
            this.fullComponent.m_130948_(newStyle);
            this.fullComponent.m_7360_().stream().map(this::getFormattableComponent).forEach(comp -> comp.m_130948_(newStyle));
            return this.fullComponent;
        }

        public void sendTo(Player ... players) {
            this.sendTo(Arrays.asList(players));
        }

        public void sendTo(Collection<Player> players) {
            for (Player player : players) {
                player.m_5661_((Component)this.create(), false);
            }
        }

        public void sendToClose(BlockPos pos, int range, List<Player> players) {
            for (Player player : players) {
                if (!(player.m_20275_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()) < (double)(range * range))) continue;
                player.m_5661_((Component)this.create(), false);
            }
        }

        public MessageBuilderColonyPlayerSelector sendTo(IColony colony) {
            return this.sendTo(colony, false);
        }

        public MessageBuilderColonyPlayerSelector sendTo(IColony colony, boolean alwaysShowColony) {
            return new MessageBuilderColonyPlayerSelector(this.create(), colony, alwaysShowColony);
        }

        private MutableComponent getFormattableComponent(Component component) {
            return component.m_6881_();
        }
    }

    public static class MessageBuilderColonyPlayerSelector {
        private final MutableComponent rootComponent;
        private final IColony colony;
        private final boolean alwaysShowColony;

        public MessageBuilderColonyPlayerSelector(MutableComponent rootComponent, IColony colony, boolean alwaysShowColony) {
            this.rootComponent = rootComponent;
            this.colony = colony;
            this.alwaysShowColony = alwaysShowColony;
        }

        public void forAllPlayers() {
            this.sendInternal(this.colony.getMessagePlayerEntities());
        }

        public void forManagers() {
            this.sendInternal(this.colony.getImportantMessageEntityPlayers());
        }

        private void sendInternal(Collection<Player> players) {
            for (Player player : players) {
                MutableComponent fullComponent = this.rootComponent.m_6881_();
                if (this.alwaysShowColony || !this.colony.isCoordInColony(player.m_9236_(), player.m_20183_())) {
                    fullComponent = Component.m_237113_((String)("[" + this.colony.getName() + "] ")).m_7220_((Component)this.rootComponent);
                }
                player.m_5661_((Component)fullComponent, false);
            }
        }
    }

    public static enum MessagePriority {
        NORMAL(ChatFormatting.GRAY),
        IMPORTANT(ChatFormatting.GOLD),
        DANGER(ChatFormatting.RED);

        private final ChatFormatting color;

        private MessagePriority(ChatFormatting color) {
            this.color = color;
        }
    }
}

