/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.util;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ShapeUtil {
    public static double max(VoxelShape shape, Direction.Axis axis) {
        if (shape == Shapes.m_83144_()) {
            return 1.0;
        }
        if (shape == Shapes.m_83040_()) {
            return 0.0;
        }
        return shape.m_83297_(axis);
    }

    public static double min(VoxelShape shape, Direction.Axis axis) {
        if (shape == Shapes.m_83144_()) {
            return 0.0;
        }
        if (shape == Shapes.m_83040_()) {
            return 0.0;
        }
        return shape.m_83288_(axis);
    }

    public static boolean isEmpty(VoxelShape shape) {
        if (shape == Shapes.m_83144_()) {
            return false;
        }
        if (shape == Shapes.m_83040_()) {
            return true;
        }
        return shape.m_83281_();
    }

    public static double getStartY(VoxelShape bb, double def) {
        return ShapeUtil.isEmpty(bb) ? def : ShapeUtil.min(bb, Direction.Axis.Y);
    }

    public static double getEndY(VoxelShape bb, double def) {
        return ShapeUtil.isEmpty(bb) ? def : ShapeUtil.max(bb, Direction.Axis.Y);
    }

    public static boolean hasCollision(BlockGetter world, BlockPos pos, BlockState state) {
        if (!state.m_60734_().f_60443_) {
            return false;
        }
        return ShapeUtil.hasCollision(state, state.m_60812_(world, pos));
    }

    public static boolean hasCollision(BlockGetter world, int x, int y, int z, BlockState state) {
        if (!state.m_60734_().f_60443_) {
            return false;
        }
        return ShapeUtil.hasCollision(state, state.m_60812_(world, new BlockPos(x, y, z)));
    }

    public static boolean hasCollision(BlockState state, VoxelShape collisionShape) {
        if (!state.m_60734_().f_60443_) {
            return false;
        }
        return !ShapeUtil.isEmpty(collisionShape);
    }
}

