/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.blocks;

import com.minecolonies.api.blocks.AbstractBlockMinecolonies;
import com.minecolonies.api.blocks.interfaces.ITickableBlockMinecolonies;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.core.items.ItemColonySign;
import com.minecolonies.core.tileentities.TileEntityColonySign;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.registries.IForgeRegistry;
import org.jetbrains.annotations.NotNull;

public class BlockColonySign
extends AbstractBlockMinecolonies<BlockColonySign>
implements ITickableBlockMinecolonies {
    public static final BooleanProperty CONNECTED = BooleanProperty.m_61465_((String)"connected");
    private static final float BLOCK_HARDNESS = 5.0f;
    private static final String BLOCK_NAME = "colonysign";
    private static final float RESISTANCE = 1.0f;
    private static final VoxelShape SHAPE = Shapes.m_83048_((double)0.1, (double)0.1, (double)0.1, (double)0.9, (double)0.9, (double)0.9);

    public BlockColonySign() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283825_).m_60918_(SoundType.f_56736_).m_60913_(5.0f, 1.0f).m_60910_());
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)CONNECTED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public ResourceLocation getRegistryName() {
        return new ResourceLocation("minecolonies", BLOCK_NAME);
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public void m_6402_(@NotNull Level worldIn, @NotNull BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        if (worldIn.f_46443_) {
            super.m_6402_(worldIn, pos, state, placer, stack);
            return;
        }
        TileEntityColonySign tileEntityColonySign = (TileEntityColonySign)worldIn.m_7702_(pos);
        CompoundTag stackCompound = stack.m_41784_();
        if (!stackCompound.m_128441_("colony")) {
            return;
        }
        int colonyId = stackCompound.m_128451_("colony");
        IColony colony = IColonyManager.getInstance().getColonyByDimension(colonyId, (ResourceKey<Level>)worldIn.m_46472_());
        tileEntityColonySign.setColonyAndAnchor(colony, stackCompound.m_128441_("pos") ? BlockPosUtil.read(stackCompound, "pos") : null);
        super.m_6402_(worldIn, pos, state, placer, stack);
    }

    public void m_6786_(LevelAccessor level, BlockPos pos, BlockState state) {
        super.m_6786_(level, pos, state);
    }

    public void m_6810_(BlockState currentState, Level level, BlockPos pos, BlockState p_60518_, boolean p_60519_) {
        BlockEntity tileEntity = level.m_7702_(pos);
        if (!level.f_46443_ && tileEntity instanceof TileEntityColonySign) {
            TileEntityColonySign tileEntityColonySign = (TileEntityColonySign)tileEntity;
            IColony colony = IColonyManager.getInstance().getColonyByDimension(tileEntityColonySign.getColonyId(), (ResourceKey<Level>)level.m_46472_());
            if (colony != null) {
                colony.getConnectionManager().removeConnectionNode(pos);
            }
        }
        super.m_6810_(currentState, level, pos, p_60518_, p_60519_);
    }

    public RenderShape m_7514_(BlockState p_60550_) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{HorizontalDirectionalBlock.f_54117_, CONNECTED});
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return new TileEntityColonySign(blockPos, blockState);
    }

    @Override
    public void registerBlockItem(IForgeRegistry<Item> registry, Item.Properties properties) {
        registry.register(this.getRegistryName(), (Object)new ItemColonySign(properties));
    }
}

