/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.blocks;

import com.ldtteam.domumornamentum.block.IMateriallyTexturedBlock;
import com.ldtteam.domumornamentum.block.IMateriallyTexturedBlockComponent;
import com.minecolonies.api.blocks.AbstractBlockMinecoloniesRack;
import com.minecolonies.api.blocks.types.RackType;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.tileentities.AbstractTileEntityRack;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.core.tileentities.TileEntityRack;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;

public class BlockMinecoloniesRack
extends AbstractBlockMinecoloniesRack<BlockMinecoloniesRack>
implements IMateriallyTexturedBlock {
    private static final Long2ObjectMap<Direction> BY_NORMAL = (Long2ObjectMap)Arrays.stream(Direction.values()).collect(Collectors.toMap(p_235679_ -> new BlockPos(p_235679_.m_122436_()).m_121878_(), p_235675_ -> p_235675_, (p_235670_, p_235671_) -> {
        throw new IllegalArgumentException("Duplicate keys");
    }, Long2ObjectOpenHashMap::new));
    private static final float BLOCK_HARDNESS = 10.0f;
    private static final String BLOCK_NAME = "blockminecoloniesrack";
    private static final float RESISTANCE = Float.POSITIVE_INFINITY;
    private static final VoxelShape SHAPE = Shapes.m_83048_((double)0.1, (double)0.1, (double)0.1, (double)0.9, (double)0.9, (double)0.9);

    public BlockMinecoloniesRack() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283825_).m_60918_(SoundType.f_56736_).m_60913_(10.0f, Float.POSITIVE_INFINITY));
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)VARIANT, (Comparable)((Object)RackType.EMPTY)));
    }

    @Override
    public ResourceLocation getRegistryName() {
        return new ResourceLocation("minecolonies", BLOCK_NAME);
    }

    public boolean m_7420_(BlockState state, @NotNull BlockGetter reader, @NotNull BlockPos pos) {
        return true;
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    @NotNull
    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        return Shapes.m_83144_();
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        if (context.m_43723_() != null) {
            return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_43723_().m_6350_().m_122424_());
        }
        return super.m_5573_(context);
    }

    @Deprecated
    @NotNull
    public BlockState m_6843_(@NotNull BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    @Deprecated
    @NotNull
    public BlockState m_6943_(@NotNull BlockState state, Mirror mirrorIn) {
        return state.m_60717_(mirrorIn.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    @NotNull
    public BlockState m_7417_(@NotNull BlockState state, @NotNull Direction dir, BlockState neighbourState, @NotNull LevelAccessor level, @NotNull BlockPos pos, @NotNull BlockPos neighbourPos) {
        if (state.m_60734_() != this || pos.m_121996_((Vec3i)neighbourPos).m_123342_() != 0) {
            return super.m_7417_(state, dir, neighbourState, level, pos, neighbourPos);
        }
        BlockEntity here = level.m_7702_(pos);
        if (!(here instanceof TileEntityRack)) {
            return super.m_7417_(state, dir, neighbourState, level, pos, neighbourPos);
        }
        TileEntityRack hereRack = (TileEntityRack)here;
        if (neighbourState.m_60734_() != this) {
            if (((RackType)((Object)state.m_61143_((Property)VARIANT))).isDoubleVariant() && pos.m_121945_((Direction)state.m_61143_((Property)FACING)).equals((Object)neighbourPos)) {
                return (BlockState)state.m_61124_((Property)VARIANT, (Comparable)((Object)(hereRack.isEmpty() ? RackType.EMPTY : RackType.FULL)));
            }
            return super.m_7417_(state, dir, neighbourState, level, pos, neighbourPos);
        }
        if (!((RackType)((Object)state.m_61143_((Property)VARIANT))).isDoubleVariant() && !((RackType)((Object)neighbourState.m_61143_((Property)VARIANT))).isDoubleVariant()) {
            BlockEntity neighbour = level.m_7702_(neighbourPos);
            if (!(neighbour instanceof TileEntityRack)) {
                return super.m_7417_(state, dir, neighbourState, level, pos, neighbourPos);
            }
            TileEntityRack neighborRack = (TileEntityRack)neighbour;
            boolean isEmpty = hereRack.isEmpty() && neighborRack.isEmpty();
            level.m_7731_(neighbourPos, (BlockState)((BlockState)neighbourState.m_61124_((Property)FACING, (Comparable)((Direction)BY_NORMAL.get(neighbourPos.m_121996_((Vec3i)pos).m_121878_())).m_122424_())).m_61124_((Property)VARIANT, (Comparable)((Object)RackType.NO_RENDER)), 1);
            return (BlockState)((BlockState)state.m_61124_((Property)VARIANT, (Comparable)((Object)(isEmpty ? RackType.EMPTY_DOUBLE : RackType.FULL_DOUBLE)))).m_61124_((Property)FACING, (Comparable)((Direction)BY_NORMAL.get(neighbourPos.m_121996_((Vec3i)pos).m_121878_())));
        }
        if (((RackType)((Object)state.m_61143_((Property)VARIANT))).isDoubleVariant() && pos.m_121945_((Direction)state.m_61143_((Property)FACING)).equals((Object)neighbourPos)) {
            if (!((Direction)neighbourState.m_61143_((Property)FACING)).equals((Object)((Direction)state.m_61143_((Property)FACING)).m_122424_()) || !((RackType)((Object)neighbourState.m_61143_((Property)VARIANT))).isDoubleVariant()) {
                return (BlockState)state.m_61124_((Property)VARIANT, (Comparable)((Object)(hereRack.isEmpty() ? RackType.EMPTY : RackType.FULL)));
            }
            if (neighbourState.m_61143_((Property)VARIANT) != RackType.NO_RENDER && state.m_61143_((Property)VARIANT) != RackType.NO_RENDER) {
                return (BlockState)state.m_61124_((Property)VARIANT, (Comparable)((Object)RackType.NO_RENDER));
            }
        }
        return super.m_7417_(state, dir, neighbourState, level, pos, neighbourPos);
    }

    public void m_213646_(BlockState state, ServerLevel worldIn, BlockPos pos, ItemStack stack, boolean p_222953_) {
        BlockEntity tileentity = worldIn.m_7702_(pos);
        if (tileentity instanceof TileEntityRack) {
            IItemHandlerModifiable handler = ((AbstractTileEntityRack)tileentity).getInventory();
            InventoryUtils.dropItemHandler((IItemHandler)handler, (Level)worldIn, pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
        }
        super.m_213646_(state, worldIn, pos, stack, p_222953_);
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand hand, BlockHitResult ray) {
        IColony colony = IColonyManager.getInstance().getColonyByPosFromWorld(worldIn, pos);
        BlockEntity tileEntity = worldIn.m_7702_(pos);
        if ((colony == null || colony.getPermissions().hasPermission(player, Action.ACCESS_HUTS)) && tileEntity instanceof TileEntityRack) {
            TileEntityRack rack = (TileEntityRack)tileEntity;
            if (!worldIn.f_46443_) {
                NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)rack, buf -> buf.m_130064_(rack.m_58899_()).m_130064_(rack.getOtherChest() == null ? BlockPos.f_121853_ : rack.getOtherChest().m_58899_()));
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, VARIANT});
    }

    @Nullable
    public BlockEntity m_142194_(@NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        return new TileEntityRack(blockPos, blockState);
    }

    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder builder) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        drops.add(new ItemStack((ItemLike)this, 1));
        return drops;
    }

    public void m_6810_(BlockState state, @NotNull Level worldIn, @NotNull BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60734_() != newState.m_60734_()) {
            BlockEntity tileEntity = worldIn.m_7702_(pos);
            if (tileEntity instanceof TileEntityRack) {
                TileEntityRack tileEntityRack = (TileEntityRack)tileEntity;
                InventoryUtils.dropItemHandler((IItemHandler)tileEntityRack.getInventory(), worldIn, tileEntityRack.m_58899_().m_123341_(), tileEntityRack.m_58899_().m_123342_(), tileEntityRack.m_58899_().m_123343_());
                worldIn.m_46717_(pos, (Block)this);
            }
            super.m_6810_(state, worldIn, pos, newState, isMoving);
        }
    }

    @NotNull
    public Block getBlock() {
        return this;
    }

    @NotNull
    public Collection<IMateriallyTexturedBlockComponent> getComponents() {
        return Collections.emptyList();
    }
}

