/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.client.gui.citizen;

import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.controls.Text;
import com.ldtteam.blockui.views.ScrollingList;
import com.minecolonies.api.colony.ICitizenDataView;
import com.minecolonies.core.client.gui.citizen.AbstractWindowCitizen;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public class FamilyWindowCitizen
extends AbstractWindowCitizen {
    private final ICitizenDataView citizen;
    protected final ScrollingList siblingList;
    protected final ScrollingList childrenList;

    public FamilyWindowCitizen(ICitizenDataView citizen) {
        super(citizen, "minecolonies:gui/citizen/family.xml");
        this.citizen = citizen;
        this.siblingList = (ScrollingList)this.findPaneOfTypeByID("siblings", ScrollingList.class);
        this.childrenList = (ScrollingList)this.findPaneOfTypeByID("children", ScrollingList.class);
    }

    @Override
    public void onOpened() {
        super.onOpened();
        String firstParent = this.citizen.getParents().getA();
        String secondParent = this.citizen.getParents().getB();
        ((Text)this.findPaneOfTypeByID("parentA", Text.class)).setText(firstParent.isEmpty() ? Component.m_237115_((String)"com.minecolonies.coremod.gui.citizen.family.unknown") : Component.m_237113_((String)firstParent));
        ((Text)this.findPaneOfTypeByID("parentB", Text.class)).setText(secondParent.isEmpty() ? Component.m_237115_((String)"com.minecolonies.coremod.gui.citizen.family.unknown") : Component.m_237113_((String)secondParent));
        int partner = this.citizen.getPartner();
        ICitizenDataView partnerView = this.colony.getCitizen(partner);
        Text partnerText = (Text)this.findPaneOfTypeByID("partner", Text.class);
        if (partnerView == null) {
            partnerText.setText(Component.m_237113_((String)"-"));
        } else {
            partnerText.setText(Component.m_237113_((String)partnerView.getName()));
        }
        this.childrenList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return FamilyWindowCitizen.this.citizen.getChildren().size();
            }

            public void updateElement(int index, @NotNull Pane rowPane) {
                ((Text)rowPane.findPaneOfTypeByID("name", Text.class)).setText(Component.m_237113_((String)FamilyWindowCitizen.this.colony.getCitizen(FamilyWindowCitizen.this.citizen.getChildren().get(index)).getName()));
            }
        });
        this.siblingList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return FamilyWindowCitizen.this.citizen.getSiblings().size();
            }

            public void updateElement(int index, @NotNull Pane rowPane) {
                ((Text)rowPane.findPaneOfTypeByID("name", Text.class)).setText(Component.m_237113_((String)FamilyWindowCitizen.this.colony.getCitizen(FamilyWindowCitizen.this.citizen.getSiblings().get(index)).getName()));
            }
        });
    }
}

