/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.client.gui.containers;

import com.minecolonies.api.blocks.AbstractBlockMinecoloniesRack;
import com.minecolonies.api.blocks.types.RackType;
import com.minecolonies.api.inventory.container.ContainerRack;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class WindowRack
extends AbstractContainerScreen<ContainerRack> {
    private static final ResourceLocation CHEST_GUI_TEXTURE = new ResourceLocation("minecolonies", "textures/gui/generic_108.png");
    private static final String LOCATION = "textures/gui/gui%s.png";
    private static final int TEXTURE_SIZE = 350;
    private static final int GOOD_SIZE = 8;
    private static final int Y_OFFSET = 114;
    private static final int TEXTURE_HEIGHT = 96;
    private static final int TEXTURE_OFFSET = 235;
    private final IItemHandler jointChestInventory;
    private final int inventoryRows;

    public WindowRack(ContainerRack container, Inventory playerInventory, Component iTextComponent) {
        super((AbstractContainerMenu)container, playerInventory, iTextComponent);
        this.jointChestInventory = container.neighborRack != null ? (container.rack.m_58900_().m_61143_(AbstractBlockMinecoloniesRack.VARIANT) != RackType.NO_RENDER ? new CombinedInvWrapper(new IItemHandlerModifiable[]{container.rack.getInventory(), container.neighborRack.getInventory()}) : new CombinedInvWrapper(new IItemHandlerModifiable[]{container.neighborRack.getInventory(), container.rack.getInventory()})) : container.rack.getInventory();
        int size = this.jointChestInventory.getSlots();
        this.inventoryRows = size / 9;
        int rows = Math.min(this.inventoryRows, 8);
        int columns = this.inventoryRows <= 8 ? 9 : size / 8 + 1;
        this.f_97727_ = 114 + rows * 18;
        if (columns > 9) {
            this.f_97726_ += (columns - 9) * 18;
        }
    }

    protected void m_280003_(@NotNull GuiGraphics stack, int mouseX, int mouseY) {
        stack.m_280056_(this.f_96547_, this.f_96539_.getString(), 8, 6, 0x404040, false);
        stack.m_280056_(this.f_96547_, this.f_169604_.getString(), 8, this.f_97727_ - 94, 0x404040, false);
    }

    protected void m_7286_(@NotNull GuiGraphics stack, float partialTicks, int mouseX, int mouseY) {
        ResourceLocation loc = WindowRack.getCorrectTextureForSlots(this.inventoryRows);
        if (this.inventoryRows <= 8) {
            int rowsHeight = this.inventoryRows * 18 + 18 - 1;
            stack.m_280163_(loc, this.f_97735_, this.f_97736_, 0.0f, 0.0f, this.f_97726_, rowsHeight, 350, 350);
            stack.m_280163_(loc, this.f_97735_, this.f_97736_ + rowsHeight, 0.0f, 235.0f, this.f_97726_, 96, 350, 350);
        } else {
            stack.m_280163_(loc, this.f_97735_, this.f_97736_, 0.0f, 0.0f, this.f_97726_, this.f_97727_, 350, 350);
        }
    }

    private static ResourceLocation getCorrectTextureForSlots(int inventoryRows) {
        if (inventoryRows <= 8) {
            return CHEST_GUI_TEXTURE;
        }
        return new ResourceLocation("minecolonies", String.format(LOCATION, inventoryRows * 9));
    }

    public void m_88315_(@NotNull GuiGraphics stack, int x, int y, float z) {
        this.m_280273_(stack);
        super.m_88315_(stack, x, y, z);
        this.m_280072_(stack, x, y);
    }
}

