/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.client.gui.modules;

import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.controls.Button;
import com.ldtteam.blockui.controls.Text;
import com.ldtteam.blockui.views.ScrollingList;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.colony.connections.ColonyConnection;
import com.minecolonies.api.colony.connections.DiplomacyStatus;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.core.Network;
import com.minecolonies.core.client.gui.AbstractModuleWindow;
import com.minecolonies.core.colony.buildings.moduleviews.ColonyConnectionModuleView;
import com.minecolonies.core.commands.ClickEventWithExecutable;
import com.minecolonies.core.network.messages.server.colony.TeleportToColonyMessage;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class ConnectionModuleWindow
extends AbstractModuleWindow {
    private static final String TRAVEL = "travel";
    private static final String LIST_DIRECT = "directcolonylist";
    private static final String LIST_INDIRECT = "indirectcolonylist";
    private final ScrollingList directConnections = (ScrollingList)this.findPaneOfTypeByID("directcolonylist", ScrollingList.class);
    private final ScrollingList indirectConnections = (ScrollingList)this.findPaneOfTypeByID("indirectcolonylist", ScrollingList.class);
    private final List<ColonyConnection> directConnectionData;
    private final List<ColonyConnection> indirectConnectionData;

    public ConnectionModuleWindow(String res, IBuildingView building, ColonyConnectionModuleView moduleView) {
        super(building, res);
        this.directConnectionData = new ArrayList<ColonyConnection>(building.getColony().getConnectionManager().getDirectlyConnectedColonies().values());
        this.indirectConnectionData = new ArrayList<ColonyConnection>(building.getColony().getConnectionManager().getIndirectlyConnectedColonies().values());
        this.registerButton(TRAVEL, this::teleportToColony);
        this.updateConnections(this.directConnections, this.directConnectionData);
        this.updateConnections(this.indirectConnections, this.indirectConnectionData);
    }

    private ColonyConnection getColonyDataFromPane(@NotNull Button button) {
        int directRow = this.directConnections.getListElementIndexByPane((Pane)button);
        if (directRow != -1) {
            return this.directConnectionData.get(directRow);
        }
        int indirectRow = this.indirectConnections.getListElementIndexByPane((Pane)button);
        return this.indirectConnectionData.get(indirectRow);
    }

    private void teleportToColony(@NotNull Button button) {
        ColonyConnection connectedColonyData = this.getColonyDataFromPane(button);
        MessageUtils.format("com.minecolonies.core.gui.colonylist.travel.really", connectedColonyData.name).withPriority(MessageUtils.MessagePriority.IMPORTANT).withClickEvent(new ClickEventWithExecutable(() -> Network.getNetwork().sendToServer(new TeleportToColonyMessage((ResourceKey<Level>)this.mc.f_91073_.m_46472_(), connectedColonyData.id, connectedColonyData.pos, this.buildingView.getColony().getID())))).sendTo(new Player[]{Minecraft.m_91087_().f_91074_});
        this.close();
    }

    private void updateConnections(ScrollingList connectionScrollList, final List<ColonyConnection> connectionData) {
        connectionScrollList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return connectionData.size();
            }

            public void updateElement(int index, @NotNull Pane rowPane) {
                ColonyConnection colonyData = (ColonyConnection)connectionData.get(index);
                ((Text)rowPane.findPaneOfTypeByID("name", Text.class)).setText(Component.m_237113_((String)colonyData.name));
                ((Text)rowPane.findPaneOfTypeByID("distance", Text.class)).setText(Component.m_237110_((String)"com.minecolonies.coremod.dist.blocks", (Object[])new Object[]{(int)BlockPosUtil.dist(colonyData.pos, ConnectionModuleWindow.this.buildingView.getColony().getCenter())}));
                ((Text)rowPane.findPaneOfTypeByID("state", Text.class)).setText(Component.m_237115_((String)colonyData.diplomacyStatus.translationKey()));
                ((Button)rowPane.findPaneOfTypeByID(ConnectionModuleWindow.TRAVEL, Button.class)).setEnabled(colonyData.diplomacyStatus == DiplomacyStatus.ALLIES && !colonyData.pos.equals((Object)BlockPos.f_121853_));
            }
        });
    }
}

