/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.client.render.worldevent;

import com.ldtteam.structurize.util.WorldRenderMacros;
import com.minecolonies.core.client.render.worldevent.RenderTypes;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.util.FastColor;
import net.minecraft.world.phys.AABB;
import org.joml.Matrix4f;

public class ColonyWorldRenderMacros {
    public static void renderLineBox(PoseStack poseStack, MultiBufferSource.BufferSource bufferSource, AABB bounds, float width, int color, boolean showThroughBlocks) {
        float halfLine = width / 2.0f;
        float minX = (float)(bounds.f_82288_ - (double)halfLine);
        float minY = (float)(bounds.f_82289_ - (double)halfLine);
        float minZ = (float)(bounds.f_82290_ - (double)halfLine);
        float minX2 = minX + width;
        float minY2 = minY + width;
        float minZ2 = minZ + width;
        float maxX = (float)(bounds.f_82291_ + (double)halfLine);
        float maxY = (float)(bounds.f_82292_ + (double)halfLine);
        float maxZ = (float)(bounds.f_82293_ + (double)halfLine);
        float maxX2 = maxX - width;
        float maxY2 = maxY - width;
        float maxZ2 = maxZ - width;
        int red = FastColor.ARGB32.m_13665_((int)color);
        int green = FastColor.ARGB32.m_13667_((int)color);
        int blue = FastColor.ARGB32.m_13669_((int)color);
        int alpha = FastColor.ARGB32.m_13655_((int)color);
        if (showThroughBlocks) {
            ColonyWorldRenderMacros.renderLineBox(poseStack, bufferSource.m_6299_(RenderTypes.LINES_INSIDE_BLOCKS), minX, minY, minZ, minX2, minY2, minZ2, maxX, maxY, maxZ, maxX2, maxY2, maxZ2, red / 2, green / 2, blue / 2, alpha / 2);
        }
        ColonyWorldRenderMacros.renderLineBox(poseStack, bufferSource.m_6299_(RenderTypes.LINES_OUTSIDE_BLOCKS), minX, minY, minZ, minX2, minY2, minZ2, maxX, maxY, maxZ, maxX2, maxY2, maxZ2, red, green, blue, alpha);
    }

    public static void endRenderLineBox(MultiBufferSource.BufferSource bufferSource) {
        bufferSource.m_109912_(RenderTypes.LINES_INSIDE_BLOCKS);
        bufferSource.m_109912_(RenderTypes.LINES_OUTSIDE_BLOCKS);
    }

    private static void renderLineBox(PoseStack poseStack, VertexConsumer buffer, float minX, float minY, float minZ, float minX2, float minY2, float minZ2, float maxX, float maxY, float maxZ, float maxX2, float maxY2, float maxZ2, int red, int green, int blue, int alpha) {
        buffer.m_7404_(red, green, blue, alpha);
        WorldRenderMacros.populateRenderLineBox((float)minX, (float)minY, (float)minZ, (float)minX2, (float)minY2, (float)minZ2, (float)maxX, (float)maxY, (float)maxZ, (float)maxX2, (float)maxY2, (float)maxZ2, (Matrix4f)poseStack.m_85850_().m_252922_(), (VertexConsumer)buffer);
        buffer.m_141991_();
    }
}

