/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.client.render.worldevent;

import com.minecolonies.core.client.render.worldevent.WorldEventContext;
import com.minecolonies.core.client.render.worldevent.highlightmanager.IHighlightRenderData;
import java.time.Duration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class HighlightManager {
    private static final Map<String, Map<String, HighlightRenderDataContainer>> HIGHLIGHT_ITEMS = new HashMap<String, Map<String, HighlightRenderDataContainer>>();

    static void render(WorldEventContext context) {
        if (HIGHLIGHT_ITEMS.isEmpty()) {
            return;
        }
        long worldTime = context.clientLevel.m_46467_();
        Iterator<Map<String, HighlightRenderDataContainer>> groups = HIGHLIGHT_ITEMS.values().iterator();
        while (groups.hasNext()) {
            Map<String, HighlightRenderDataContainer> group = groups.next();
            Iterator<HighlightRenderDataContainer> containers = group.values().iterator();
            while (containers.hasNext()) {
                HighlightRenderDataContainer renderDataContainer = containers.next();
                renderDataContainer.attemptStart(context);
                IHighlightRenderData renderData = renderDataContainer.data;
                if (renderDataContainer.isExpired(worldTime)) {
                    renderData.stopRender(context);
                    containers.remove();
                    continue;
                }
                renderData.render(context);
            }
            if (!group.isEmpty()) continue;
            groups.remove();
        }
    }

    public static void clearHighlightsForKey(String key) {
        HIGHLIGHT_ITEMS.remove(key);
    }

    public static void addHighlight(String key, String subKey, IHighlightRenderData data) {
        HIGHLIGHT_ITEMS.computeIfAbsent(key, k -> new HashMap()).put(subKey, new HighlightRenderDataContainer(data));
    }

    private static class HighlightRenderDataContainer {
        private final IHighlightRenderData data;
        private long startTime = 0L;

        private HighlightRenderDataContainer(IHighlightRenderData data) {
            this.data = data;
        }

        private boolean isExpired(long worldTime) {
            Duration duration = this.data.getDuration();
            if (duration != null) {
                return this.startTime + duration.getSeconds() * 20L < worldTime;
            }
            return false;
        }

        private void attemptStart(WorldEventContext context) {
            if (this.startTime == 0L) {
                this.startTime = context.clientLevel.m_46467_();
                this.data.startRender(context);
            }
        }
    }
}

