/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.client.render.worldevent.highlightmanager;

import com.minecolonies.api.colony.ICitizenDataView;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.core.client.render.worldevent.WorldEventContext;
import com.minecolonies.core.client.render.worldevent.highlightmanager.IHighlightRenderData;
import com.minecolonies.core.entity.citizen.EntityCitizen;
import java.time.Duration;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.Nullable;

public class CitizenRenderData
implements IHighlightRenderData {
    private final int citizenId;
    private final Duration duration;

    public CitizenRenderData(int citizenId, Duration duration) {
        this.citizenId = citizenId;
        this.duration = duration;
    }

    @Override
    public void startRender(WorldEventContext context) {
        EntityCitizen citizenEntity = this.getCitizenEntity(context);
        if (citizenEntity != null) {
            citizenEntity.setGlowing(true);
        }
    }

    @Override
    public void render(WorldEventContext context) {
    }

    @Override
    public void stopRender(WorldEventContext context) {
        EntityCitizen citizenEntity = this.getCitizenEntity(context);
        if (citizenEntity != null) {
            citizenEntity.setGlowing(false);
        }
    }

    @Override
    @Nullable
    public Duration getDuration() {
        return this.duration;
    }

    @Nullable
    private EntityCitizen getCitizenEntity(WorldEventContext context) {
        EntityCitizen entityCitizen;
        IColonyView colony = context.nearestColony;
        if (colony == null) {
            return null;
        }
        ICitizenDataView citizen = colony.getCitizen(this.citizenId);
        if (citizen == null) {
            return null;
        }
        Entity entity = colony.getWorld().m_6815_(citizen.getEntityId());
        return entity instanceof EntityCitizen ? (entityCitizen = (EntityCitizen)entity) : null;
    }
}

