/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.buildings.registry;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.ModBuildings;
import com.minecolonies.api.colony.buildings.registry.BuildingEntry;
import com.minecolonies.api.colony.buildings.registry.IBuildingDataManager;
import com.minecolonies.api.colony.buildings.registry.IBuildingRegistry;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.tileentities.AbstractTileEntityColonyBuilding;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.Log;
import com.minecolonies.core.client.gui.WindowBuildingBrowser;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

public class BuildingDataManager
implements IBuildingDataManager {
    @Override
    public IBuilding createFrom(IColony colony, CompoundTag compound) {
        ResourceLocation type = new ResourceLocation(compound.m_128461_("type"));
        BlockPos pos = BlockPosUtil.read(compound, "location");
        IBuilding building = this.createFrom(colony, pos, type);
        if (building == null) {
            return null;
        }
        try {
            building.deserializeNBT(compound);
        }
        catch (Exception ex) {
            Log.getLogger().error(String.format("A Building %s(%s) has thrown an exception during loading, its state cannot be restored. Report this to the mod author", type, building.getClass().getName()), (Throwable)ex);
            building = null;
        }
        return building;
    }

    @Override
    public IBuilding createFrom(IColony colony, AbstractTileEntityColonyBuilding tileEntityColonyBuilding) {
        return this.createFrom(colony, tileEntityColonyBuilding.getPosition(), tileEntityColonyBuilding.getBuildingName());
    }

    @Override
    public IBuilding createFrom(IColony colony, BlockPos position, ResourceLocation buildingName) {
        BuildingEntry entry = (BuildingEntry)IBuildingRegistry.getInstance().getValue(buildingName);
        if (entry == null) {
            if (buildingName.m_135815_().equals("home")) {
                return ((BuildingEntry)ModBuildings.home.get()).produceBuilding(position, colony);
            }
            Log.getLogger().error(String.format("Unknown building type '%s'.", buildingName), (Throwable)new Exception());
            return null;
        }
        return entry.produceBuilding(position, colony);
    }

    @Override
    public IBuildingView createViewFrom(IColonyView colony, BlockPos position, FriendlyByteBuf networkBuffer) {
        ResourceLocation buildingName = new ResourceLocation(networkBuffer.m_130136_(Short.MAX_VALUE));
        BuildingEntry entry = (BuildingEntry)IBuildingRegistry.getInstance().getValue(buildingName);
        if (entry == null) {
            Log.getLogger().error(String.format("Unknown building type '%s'.", buildingName), (Throwable)new Exception());
            return null;
        }
        IBuildingView view = entry.produceBuildingView(position, colony);
        if (view != null) {
            view.deserialize(networkBuffer);
        }
        return view;
    }

    @Override
    public void openBuildingBrowser(@NotNull Block block) {
        new WindowBuildingBrowser(block).open();
    }
}

