/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.buildings.workerbuildings;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.jobs.registry.JobEntry;
import com.minecolonies.api.crafting.IGenericRecipe;
import com.minecolonies.api.util.CraftingUtils;
import com.minecolonies.api.util.OptionalPredicate;
import com.minecolonies.api.util.constant.TagConstants;
import com.minecolonies.core.colony.buildings.AbstractBuilding;
import com.minecolonies.core.colony.buildings.modules.AbstractCraftingBuildingModule;
import com.minecolonies.core.colony.buildings.modules.AbstractDOCraftingBuildingModule;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.DyeableArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class BuildingFletcher
extends AbstractBuilding {
    protected static final String FLETCHER = "fletcher";

    public BuildingFletcher(IColony c, BlockPos l) {
        super(c, l);
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return FLETCHER;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    public static class DOCraftingModule
    extends AbstractDOCraftingBuildingModule {
        public DOCraftingModule(JobEntry jobEntry) {
            super(jobEntry);
        }

        @NotNull
        public static OptionalPredicate<ItemStack> getStaticIngredientValidator() {
            return CraftingUtils.getIngredientValidatorBasedOnTags(TagConstants.CRAFTING_FLETCHER, true);
        }

        @Override
        @NotNull
        public OptionalPredicate<ItemStack> getIngredientValidator() {
            return DOCraftingModule.getStaticIngredientValidator();
        }
    }

    public static class CraftingModule
    extends AbstractCraftingBuildingModule.Crafting {
        public CraftingModule(JobEntry jobEntry) {
            super(jobEntry);
        }

        @Override
        @NotNull
        public OptionalPredicate<ItemStack> getIngredientValidator() {
            return CraftingUtils.getIngredientValidatorBasedOnTags(TagConstants.CRAFTING_FLETCHER).combine(super.getIngredientValidator());
        }

        @Override
        public boolean isRecipeCompatible(@NotNull IGenericRecipe recipe) {
            if (!super.isRecipeCompatible(recipe)) {
                return false;
            }
            Optional<Boolean> isRecipeAllowed = CraftingUtils.isRecipeCompatibleBasedOnTags(recipe, TagConstants.CRAFTING_FLETCHER);
            if (isRecipeAllowed.isPresent()) {
                return isRecipeAllowed.get();
            }
            Item output = recipe.getPrimaryOutput().m_41720_();
            return output instanceof ArrowItem || output instanceof DyeableArmorItem && ((DyeableArmorItem)output).m_40401_() == ArmorMaterials.LEATHER;
        }
    }
}

