/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.buildings.workerbuildings;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.util.Log;
import com.minecolonies.core.colony.buildings.AbstractBuildingGuards;
import com.minecolonies.core.colony.buildings.modules.BuildingModules;
import com.minecolonies.core.colony.buildings.modules.GuardBuildingModule;
import net.minecraft.core.BlockPos;
import org.jetbrains.annotations.NotNull;

public class BuildingGateHouse
extends AbstractBuildingGuards {
    private static final String SCHEMATIC_NAME = "gatehouse";
    private static final int MAX_LEVEL = 3;

    public BuildingGateHouse(@NotNull IColony c, BlockPos l) {
        super(c, l);
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return SCHEMATIC_NAME;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 3;
    }

    @Override
    public int getMaxEquipmentLevel() {
        if (this.getBuildingLevel() >= this.getMaxBuildingLevel()) {
            return Integer.MAX_VALUE;
        }
        if (this.getBuildingLevelEquivalent() <= 0) {
            return 1;
        }
        return this.getBuildingLevelEquivalent() - 0;
    }

    @Override
    public int getClaimRadius(int newLevel) {
        return switch (newLevel) {
            case 1, 2 -> 1;
            case 3 -> 2;
            default -> 0;
        };
    }

    @Override
    public int getBonusVision() {
        return 15 + this.getBuildingLevelEquivalent() * 3;
    }

    @Override
    public int getBonusHealth() {
        return this.getBuildingLevelEquivalent() * 2;
    }

    @Override
    public int getBuildingLevelEquivalent() {
        return switch (this.getBuildingLevel()) {
            case 1 -> 1;
            case 2 -> 3;
            case 3 -> 5;
            default -> 0;
        };
    }

    @Override
    public int getBuildingLevel() {
        return super.getBuildingLevel();
    }

    @Override
    public BlockPos getGuardPos(@NotNull AbstractEntityCitizen worker) {
        if (this.getLocationsFromTag("knight").size() < 2 || this.getLocationsFromTag("archer").size() < 2) {
            Log.getLogger().error("GateHouse at " + this.getID().m_123344_() + " missing 'work' tag for guards of: " + this.getStructurePack() + " : " + this.getBlueprintPath());
            return this.getID();
        }
        GuardBuildingModule knightWorkModule = this.getModule(BuildingModules.KNIGHT_GATE_WORK);
        GuardBuildingModule archerWorkModule = this.getModule(BuildingModules.RANGER_GATE_WORK);
        int firstIndex = knightWorkModule.getAssignedCitizen().indexOf(worker.getCitizenData());
        if (firstIndex >= 0) {
            return this.getLocationsFromTag("knight").get(firstIndex);
        }
        int secondIndex = archerWorkModule.getAssignedCitizen().indexOf(worker.getCitizenData());
        if (secondIndex >= 0) {
            return this.getLocationsFromTag("archer").get(secondIndex);
        }
        return this.getID();
    }

    @Override
    public String getTask() {
        return "com.minecolonies.core.guard.setting.guard";
    }

    @Override
    public void onDestroyed() {
        super.onDestroyed();
        this.colony.getBuildingManager().guardBuildingChangedAt(this, 0);
    }

    @Override
    public void onUpgradeComplete(int newLevel) {
        super.onUpgradeComplete(newLevel);
        this.colony.getBuildingManager().guardBuildingChangedAt(this, newLevel);
    }

    @Override
    public boolean requiresManualTarget() {
        return (this.patrolTargets == null || this.patrolTargets.isEmpty() || this.tempNextPatrolPoint != null || !this.shallPatrolManually()) && this.tempNextPatrolPoint == null;
    }

    @Override
    public void setBuildingLevel(int level) {
        super.setBuildingLevel(level);
        if (level >= 1) {
            this.colony.getConnectionManager().addNewGateHouse(this.getPosition());
        }
    }

    @Override
    public void destroy() {
        this.colony.getConnectionManager().removeGateHouse(this.getPosition());
        super.destroy();
    }

    public static class View
    extends AbstractBuildingGuards.View {
        public View(IColonyView c, @NotNull BlockPos l) {
            super(c, l);
        }
    }
}

