/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.buildings.workerbuildings;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.util.MathUtils;
import com.minecolonies.core.colony.buildings.AbstractBuilding;
import com.minecolonies.core.datalistener.StudyItemListener;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.Tags;
import org.jetbrains.annotations.NotNull;

public class BuildingLibrary
extends AbstractBuilding {
    private static final String LIBRARY_HUT_NAME = "library";
    private static final int MAX_BUILDING_LEVEL = 5;
    private final List<BlockPos> bookCases = new ArrayList<BlockPos>();

    public BuildingLibrary(IColony c, BlockPos l) {
        super(c, l);
        this.keepX.put(StudyItemListener::isStudyItem, new Tuple((Object)64, (Object)true));
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return LIBRARY_HUT_NAME;
    }

    @Override
    public void deserializeNBT(CompoundTag compound) {
        super.deserializeNBT(compound);
        ListTag furnaceTagList = compound.m_128437_("bookcase", 10);
        for (int i = 0; i < furnaceTagList.size(); ++i) {
            this.bookCases.add(NbtUtils.m_129239_((CompoundTag)furnaceTagList.m_128728_(i).m_128469_("pos")));
        }
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag compound = super.serializeNBT();
        @NotNull ListTag bookcaseTagList = new ListTag();
        for (BlockPos entry : this.bookCases) {
            @NotNull CompoundTag bookCompound = new CompoundTag();
            bookCompound.m_128365_("pos", (Tag)NbtUtils.m_129224_((BlockPos)entry));
            bookcaseTagList.add((Object)bookCompound);
        }
        compound.m_128365_("bookcase", (Tag)bookcaseTagList);
        return compound;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    public void registerBlockPosition(@NotNull Block block, @NotNull BlockPos pos, @NotNull Level world) {
        super.registerBlockPosition(block, pos, world);
        if (block.m_49966_().m_204336_(Tags.Blocks.BOOKSHELVES)) {
            this.bookCases.add(pos);
        }
    }

    public BlockPos getRandomBookShelf() {
        if (this.bookCases.isEmpty()) {
            return this.getPosition();
        }
        BlockPos returnPos = this.bookCases.get(MathUtils.RANDOM.nextInt(this.bookCases.size()));
        if (this.colony.getWorld().m_8055_(returnPos).m_204336_(Tags.Blocks.BOOKSHELVES)) {
            return returnPos;
        }
        this.bookCases.remove(returnPos);
        return this.getPosition();
    }
}

