/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.jobs;

import com.minecolonies.api.client.render.modeltype.ModModelTypes;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.core.colony.buildings.modules.BuildingModules;
import com.minecolonies.core.colony.buildings.modules.HospitalAssignmentModule;
import com.minecolonies.core.colony.jobs.AbstractJob;
import com.minecolonies.core.entity.ai.workers.service.EntityAIWorkHealer;
import com.minecolonies.core.util.AttributeModifierUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import org.jetbrains.annotations.NotNull;

public class JobHealer
extends AbstractJob<EntityAIWorkHealer, JobHealer> {
    public static final double BONUS_SPEED_PER_LEVEL = 0.003;

    public JobHealer(ICitizenData entity) {
        super(entity);
    }

    @Override
    @NotNull
    public ResourceLocation getModel() {
        return ModModelTypes.HEALER_ID;
    }

    @Override
    @NotNull
    public EntityAIWorkHealer generateAI() {
        return new EntityAIWorkHealer(this);
    }

    @Override
    public void onLevelUp() {
        if (this.getCitizen().getEntity().isPresent()) {
            AbstractEntityCitizen worker = this.getCitizen().getEntity().get();
            AttributeModifier speedModifier = new AttributeModifier("SkillSpeedBonus", (double)this.getCitizen().getCitizenSkillHandler().getLevel(((HospitalAssignmentModule)this.getCitizen().getWorkBuilding().getModule(BuildingModules.HEALER_WORK)).getPrimarySkill()) * 0.003, AttributeModifier.Operation.ADDITION);
            AttributeModifierUtils.addModifier((LivingEntity)worker, speedModifier, Attributes.f_22279_);
        }
    }

    @Override
    public double getDiseaseModifier() {
        return 0.0;
    }
}

