/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.requestable;

import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import com.minecolonies.api.colony.requestsystem.requestable.IDeliverable;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.ReflectionUtils;
import com.minecolonies.api.util.constant.TypeConstants;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class SmeltableOre
implements IDeliverable {
    private static final Set<TypeToken<?>> TYPE_TOKENS = ReflectionUtils.getSuperClasses(TypeToken.of(SmeltableOre.class)).stream().filter(type -> !type.equals(TypeConstants.OBJECT)).collect(Collectors.toSet());
    private static final String NBT_COUNT = "Count";
    private static final String NBT_RESULT = "Result";
    private final int count;
    private ItemStack result;

    public SmeltableOre(int count) {
        this.count = count;
    }

    public SmeltableOre(int count, ItemStack result) {
        this.count = count;
        this.result = result;
    }

    public static CompoundTag serialize(IFactoryController controller, SmeltableOre ore) {
        CompoundTag compound = new CompoundTag();
        compound.m_128405_(NBT_COUNT, ore.count);
        if (!ItemStackUtils.isEmpty(ore.result)) {
            compound.m_128365_(NBT_RESULT, (Tag)ore.result.serializeNBT());
        }
        return compound;
    }

    public static SmeltableOre deserialize(IFactoryController controller, CompoundTag compound) {
        int count = compound.m_128451_(NBT_COUNT);
        ItemStack result = compound.m_128441_(NBT_RESULT) ? ItemStackUtils.deserializeFromNBT(compound.m_128469_(NBT_RESULT)) : ItemStackUtils.EMPTY;
        return new SmeltableOre(count, result);
    }

    public static void serialize(IFactoryController controller, FriendlyByteBuf buffer, SmeltableOre input) {
        buffer.writeInt(input.getCount());
        buffer.writeBoolean(!ItemStackUtils.isEmpty(input.result));
        if (!ItemStackUtils.isEmpty(input.result)) {
            buffer.m_130055_(input.result);
        }
    }

    public static SmeltableOre deserialize(IFactoryController controller, FriendlyByteBuf buffer) {
        int count = buffer.readInt();
        ItemStack result = buffer.readBoolean() ? buffer.m_130267_() : ItemStack.f_41583_;
        return new SmeltableOre(count, result);
    }

    @Override
    public boolean matches(@NotNull ItemStack stack) {
        return IColonyManager.getInstance().getCompatibilityManager().isOre(stack);
    }

    @Override
    public void setResult(@NotNull ItemStack result) {
        this.result = result;
    }

    @Override
    public IDeliverable copyWithCount(int newCount) {
        return new SmeltableOre(newCount);
    }

    @Override
    public int getCount() {
        return this.count;
    }

    @Override
    public int getMinimumCount() {
        return 1;
    }

    @Override
    @NotNull
    public ItemStack getResult() {
        return this.result;
    }

    @Override
    public Set<TypeToken<?>> getSuperClasses() {
        return TYPE_TOKENS;
    }
}

