/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.requestsystem.data;

import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.api.colony.requestsystem.data.IRequestSystemBuildingDataStore;
import com.minecolonies.api.colony.requestsystem.factory.FactoryVoidInput;
import com.minecolonies.api.colony.requestsystem.factory.IFactory;
import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.util.constant.TypeConstants;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import org.jetbrains.annotations.NotNull;

public class StandardRequestSystemBuildingDataStore
implements IRequestSystemBuildingDataStore {
    private IToken<?> id;
    private final Map<TypeToken<?>, Collection<IToken<?>>> openRequestsByRequestableType;
    private final Int2ObjectMap<Collection<IToken<?>>> openRequestsByCitizen;
    private final Int2ObjectMap<Collection<IToken<?>>> completedRequestsByCitizen;
    private final Object2IntMap<IToken<?>> citizenByOpenRequest;

    public StandardRequestSystemBuildingDataStore(IToken<?> id, Map<TypeToken<?>, Collection<IToken<?>>> openRequestsByRequestableType, Int2ObjectMap<Collection<IToken<?>>> openRequestsByCitizen, Int2ObjectMap<Collection<IToken<?>>> completedRequestsByCitizen, Object2IntMap<IToken<?>> citizenByOpenRequest) {
        this.id = id;
        this.openRequestsByRequestableType = openRequestsByRequestableType;
        this.openRequestsByCitizen = openRequestsByCitizen;
        this.completedRequestsByCitizen = completedRequestsByCitizen;
        this.citizenByOpenRequest = citizenByOpenRequest;
    }

    public StandardRequestSystemBuildingDataStore() {
        this(StandardFactoryController.getInstance().getNewInstance(TypeConstants.ITOKEN), new HashMap(), (Int2ObjectMap<Collection<IToken<?>>>)new Int2ObjectOpenHashMap(), (Int2ObjectMap<Collection<IToken<?>>>)new Int2ObjectOpenHashMap(), (Object2IntMap<IToken<?>>)new Object2IntOpenHashMap());
    }

    @Override
    public Map<TypeToken<?>, Collection<IToken<?>>> getOpenRequestsByRequestableType() {
        return this.openRequestsByRequestableType;
    }

    @Override
    public Map<Integer, Collection<IToken<?>>> getOpenRequestsByCitizen() {
        return this.openRequestsByCitizen;
    }

    @Override
    public Map<Integer, Collection<IToken<?>>> getCompletedRequestsByCitizen() {
        return this.completedRequestsByCitizen;
    }

    @Override
    public Map<IToken<?>, Integer> getCitizensByRequest() {
        return this.citizenByOpenRequest;
    }

    @Override
    public void moveToSyncCitizen(ICitizenData citizenData, IRequest<?> request) {
        Collection list;
        if (this.citizenByOpenRequest.getOrDefault(request.getId(), Integer.MAX_VALUE) == -1) {
            this.citizenByOpenRequest.removeInt(request.getId());
            this.citizenByOpenRequest.put(request.getId(), citizenData.getId());
            ((Collection)this.openRequestsByCitizen.getOrDefault(-1, new ArrayList())).remove(request.getId());
            list = (Collection)this.openRequestsByCitizen.getOrDefault(citizenData.getId(), new ArrayList());
            list.add(request.getId());
            this.openRequestsByCitizen.put(citizenData.getId(), (Object)list);
        }
        if (((Collection)this.completedRequestsByCitizen.getOrDefault(-1, new ArrayList())).contains(request.getId())) {
            ((Collection)this.completedRequestsByCitizen.get(-1)).remove(request.getId());
            list = (Collection)this.completedRequestsByCitizen.getOrDefault(citizenData.getId(), new ArrayList());
            list.add(request.getId());
            this.completedRequestsByCitizen.put(citizenData.getId(), (Object)list);
        }
        citizenData.getJob().markRequestSync((IToken<?>)request.getId());
    }

    @Override
    public IToken<?> getId() {
        return this.id;
    }

    @Override
    public void setId(IToken<?> id) {
        this.id = id;
    }

    public static class Factory
    implements IFactory<FactoryVoidInput, StandardRequestSystemBuildingDataStore> {
        @Override
        @NotNull
        public TypeToken<? extends StandardRequestSystemBuildingDataStore> getFactoryOutputType() {
            return TypeToken.of(StandardRequestSystemBuildingDataStore.class);
        }

        @Override
        @NotNull
        public TypeToken<? extends FactoryVoidInput> getFactoryInputType() {
            return TypeConstants.FACTORYVOIDINPUT;
        }

        @Override
        @NotNull
        public StandardRequestSystemBuildingDataStore getNewInstance(@NotNull IFactoryController factoryController, @NotNull FactoryVoidInput factoryVoidInput, Object ... context) throws IllegalArgumentException {
            return new StandardRequestSystemBuildingDataStore();
        }

        @Override
        @NotNull
        public CompoundTag serialize(@NotNull IFactoryController controller, @NotNull StandardRequestSystemBuildingDataStore dataStore) {
            CompoundTag compound = new CompoundTag();
            compound.m_128365_("Token", (Tag)controller.serialize(dataStore.id));
            ListTag openRequestsByRequestableTag = new ListTag();
            for (Map.Entry<TypeToken<?>, Collection<IToken<?>>> entry : dataStore.openRequestsByRequestableType.entrySet()) {
                CompoundTag entryCompound = new CompoundTag();
                entryCompound.m_128365_("Token", (Tag)controller.serialize(entry.getKey()));
                entryCompound.m_128365_("List", controller.serializeList(entry.getValue()));
                openRequestsByRequestableTag.add((Object)entryCompound);
            }
            compound.m_128365_("OpenRequestByRequestableType", (Tag)openRequestsByRequestableTag);
            ListTag openRequestsByCitizenTag = new ListTag();
            for (Map.Entry data : dataStore.openRequestsByCitizen.entrySet()) {
                CompoundTag entryCompound = new CompoundTag();
                entryCompound.m_128365_("Token", (Tag)controller.serialize((Integer)data.getKey()));
                entryCompound.m_128365_("List", controller.serializeList((Collection)data.getValue()));
                openRequestsByCitizenTag.add((Object)entryCompound);
            }
            compound.m_128365_("OpenRequestByCitizen", (Tag)openRequestsByCitizenTag);
            ListTag listTag = new ListTag();
            for (Map.Entry data : dataStore.completedRequestsByCitizen.entrySet()) {
                CompoundTag entryCompound = new CompoundTag();
                entryCompound.m_128365_("Token", (Tag)controller.serialize((Integer)data.getKey()));
                entryCompound.m_128365_("List", controller.serializeList((Collection)data.getValue()));
                listTag.add((Object)entryCompound);
            }
            compound.m_128365_("CompletedRequestByCitizen", (Tag)listTag);
            ListTag citizenByOpenRequestTag = new ListTag();
            for (Map.Entry data : dataStore.citizenByOpenRequest.entrySet()) {
                CompoundTag entryCompound = new CompoundTag();
                entryCompound.m_128365_("Token", (Tag)controller.serialize((IToken)data.getKey()));
                entryCompound.m_128365_("Value", (Tag)controller.serialize((Integer)data.getValue()));
                citizenByOpenRequestTag.add((Object)entryCompound);
            }
            compound.m_128365_("CitizenByOpenRequest", (Tag)citizenByOpenRequestTag);
            return compound;
        }

        @Override
        @NotNull
        public StandardRequestSystemBuildingDataStore deserialize(@NotNull IFactoryController controller, @NotNull CompoundTag nbt) throws Throwable {
            IToken token = (IToken)controller.deserialize(nbt.m_128469_("Token"));
            HashMap openRequestsByRequestableType = new HashMap();
            for (Object tag : nbt.m_128437_("OpenRequestByRequestableType", 10)) {
                CompoundTag compoundTag = (CompoundTag)tag;
                openRequestsByRequestableType.put((TypeToken)controller.deserialize(compoundTag.m_128469_("Token")), controller.deserializeList(compoundTag.m_128437_("List", 10)));
            }
            Int2ObjectOpenHashMap openRequestsByCitizen = new Int2ObjectOpenHashMap();
            for (Object tag : nbt.m_128437_("OpenRequestByCitizen", 10)) {
                CompoundTag compoundTag = (CompoundTag)tag;
                openRequestsByCitizen.put((Integer)controller.deserialize(compoundTag.m_128469_("Token")), controller.deserializeList(compoundTag.m_128437_("List", 10)));
            }
            Int2ObjectOpenHashMap completedRequestsByCitizen = new Int2ObjectOpenHashMap();
            for (Tag tag : nbt.m_128437_("CompletedRequestByCitizen", 10)) {
                CompoundTag compoundTag = (CompoundTag)tag;
                completedRequestsByCitizen.put((Integer)controller.deserialize(compoundTag.m_128469_("Token")), controller.deserializeList(compoundTag.m_128437_("List", 10)));
            }
            Object2IntOpenHashMap citizenByOpenRequest = new Object2IntOpenHashMap();
            for (Tag tag : nbt.m_128437_("CitizenByOpenRequest", 10)) {
                CompoundTag compoundTag = (CompoundTag)tag;
                citizenByOpenRequest.put((Object)((IToken)controller.deserialize(compoundTag.m_128469_("Token"))), (Integer)controller.deserialize(compoundTag.m_128469_("Value")));
            }
            return new StandardRequestSystemBuildingDataStore(token, openRequestsByRequestableType, (Int2ObjectMap<Collection<IToken<?>>>)openRequestsByCitizen, (Int2ObjectMap<Collection<IToken<?>>>)completedRequestsByCitizen, (Object2IntMap<IToken<?>>)citizenByOpenRequest);
        }

        @Override
        public void serialize(@NotNull IFactoryController controller, @NotNull StandardRequestSystemBuildingDataStore input, @NotNull FriendlyByteBuf packetBuffer) {
            controller.serialize(packetBuffer, input.id);
            packetBuffer.writeInt(input.openRequestsByRequestableType.size());
            input.openRequestsByRequestableType.forEach((key, value) -> {
                controller.serialize(packetBuffer, key);
                packetBuffer.writeInt(value.size());
                value.forEach(token -> controller.serialize(packetBuffer, token));
            });
            packetBuffer.writeInt(input.openRequestsByCitizen.size());
            input.openRequestsByCitizen.forEach((key, value) -> {
                packetBuffer.writeInt(key.intValue());
                packetBuffer.writeInt(value.size());
                value.forEach(token -> controller.serialize(packetBuffer, token));
            });
            packetBuffer.writeInt(input.completedRequestsByCitizen.size());
            input.completedRequestsByCitizen.forEach((key, value) -> {
                packetBuffer.writeInt(key.intValue());
                packetBuffer.writeInt(value.size());
                value.forEach(token -> controller.serialize(packetBuffer, token));
            });
            packetBuffer.writeInt(input.citizenByOpenRequest.size());
            input.citizenByOpenRequest.forEach((key, value) -> {
                controller.serialize(packetBuffer, key);
                controller.serialize(packetBuffer, value);
            });
        }

        @Override
        public StandardRequestSystemBuildingDataStore deserialize(@NotNull IFactoryController controller, @NotNull FriendlyByteBuf buffer) throws Throwable {
            IToken id = (IToken)controller.deserialize(buffer);
            HashMap openRequestsByRequestableType = new HashMap();
            int openRequestsByRequestableTypeSize = buffer.readInt();
            for (int i = 0; i < openRequestsByRequestableTypeSize; ++i) {
                TypeToken key = (TypeToken)controller.deserialize(buffer);
                ArrayList<IToken> tokens = new ArrayList<IToken>();
                int tokensSize = buffer.readInt();
                for (int ii = 0; ii < tokensSize; ++ii) {
                    tokens.add((IToken)controller.deserialize(buffer));
                }
                openRequestsByRequestableType.put(key, tokens);
            }
            Int2ObjectOpenHashMap openRequestsByCitizen = new Int2ObjectOpenHashMap();
            int openRequestsByCitizenSize = buffer.readInt();
            for (int i = 0; i < openRequestsByCitizenSize; ++i) {
                int key = buffer.readInt();
                ArrayList<IToken> tokens = new ArrayList<IToken>();
                int tokensSize = buffer.readInt();
                for (int ii = 0; ii < tokensSize; ++ii) {
                    tokens.add((IToken)controller.deserialize(buffer));
                }
                openRequestsByCitizen.put(key, tokens);
            }
            Int2ObjectOpenHashMap completedRequestsByCitizen = new Int2ObjectOpenHashMap();
            int completedRequestsByCitizenSize = buffer.readInt();
            for (int i = 0; i < completedRequestsByCitizenSize; ++i) {
                int key = buffer.readInt();
                ArrayList<IToken> tokens = new ArrayList<IToken>();
                int tokensSize = buffer.readInt();
                for (int ii = 0; ii < tokensSize; ++ii) {
                    tokens.add((IToken)controller.deserialize(buffer));
                }
                completedRequestsByCitizen.put(key, tokens);
            }
            Object2IntOpenHashMap citizenByOpenRequest = new Object2IntOpenHashMap();
            int citizenByOpenRequestSize = buffer.readInt();
            for (int i = 0; i < citizenByOpenRequestSize; ++i) {
                citizenByOpenRequest.put((Object)((IToken)controller.deserialize(buffer)), ((Integer)controller.deserialize(buffer)).intValue());
            }
            return new StandardRequestSystemBuildingDataStore(id, openRequestsByRequestableType, (Int2ObjectMap<Collection<IToken<?>>>)openRequestsByCitizen, (Int2ObjectMap<Collection<IToken<?>>>)completedRequestsByCitizen, (Object2IntMap<IToken<?>>)citizenByOpenRequest);
        }

        @Override
        public short getSerializationId() {
            return 37;
        }
    }
}

