/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.datalistener;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.core.Network;
import com.minecolonies.core.datalistener.model.Disease;
import com.minecolonies.core.network.messages.client.colony.GlobalDiseaseSyncMessage;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.util.random.WeightedRandomList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiseasesListener
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final String KEY_NAME = "name";
    private static final String KEY_RARITY = "rarity";
    private static final String KEY_ITEMS = "items";
    private static WeightedRandomList<Disease> DISEASES = WeightedRandomList.m_146332_();

    public DiseasesListener() {
        super(GSON, "colony/diseases");
    }

    public static void sendGlobalDiseasesPackets(ServerPlayer player) {
        FriendlyByteBuf byteBuf = new FriendlyByteBuf(Unpooled.buffer());
        byteBuf.writeInt(DISEASES.m_146338_().size());
        for (Disease disease : DISEASES.m_146338_()) {
            byteBuf.m_130085_(disease.id());
            byteBuf.m_130083_(disease.name());
            byteBuf.writeInt(disease.rarity());
            byteBuf.writeInt(disease.cureItems().size());
            for (ItemStorage cureItem : disease.cureItems()) {
                StandardFactoryController.getInstance().serialize(byteBuf, cureItem);
            }
        }
        Network.getNetwork().sendToPlayer(new GlobalDiseaseSyncMessage(byteBuf), player);
    }

    public static void readGlobalDiseasesPackets(FriendlyByteBuf byteBuf) {
        ArrayList<Disease> newDiseases = new ArrayList<Disease>();
        int size = byteBuf.readInt();
        for (int i = 0; i < size; ++i) {
            ResourceLocation id = byteBuf.m_130281_();
            Component name = byteBuf.m_130238_();
            int rarity = byteBuf.readInt();
            ArrayList<ItemStorage> cureItems = new ArrayList<ItemStorage>();
            int itemCount = byteBuf.readInt();
            for (int j = 0; j < itemCount; ++j) {
                cureItems.add((ItemStorage)StandardFactoryController.getInstance().deserialize(byteBuf));
            }
            newDiseases.add(new Disease(id, name, rarity, cureItems));
        }
        DISEASES = WeightedRandomList.m_146328_(newDiseases);
    }

    @NotNull
    public static List<Disease> getDiseases() {
        return DISEASES.m_146338_();
    }

    @Nullable
    public static Disease getDisease(ResourceLocation id) {
        for (Disease disease : DISEASES.m_146338_()) {
            if (!disease.id().equals((Object)id)) continue;
            return disease;
        }
        return null;
    }

    @Nullable
    public static Disease getRandomDisease(RandomSource random) {
        return DISEASES.m_216829_(random).orElse(null);
    }

    protected void apply(@NotNull Map<ResourceLocation, JsonElement> jsonElementMap, @NotNull ResourceManager resourceManager, @NotNull ProfilerFiller profiler) {
        ArrayList<Disease> diseases = new ArrayList<Disease>();
        for (Map.Entry<ResourceLocation, JsonElement> entry : jsonElementMap.entrySet()) {
            if (!entry.getValue().isJsonObject()) {
                return;
            }
            JsonObject object = entry.getValue().getAsJsonObject();
            MutableComponent name = Component.m_237115_((String)GsonHelper.m_13906_((JsonObject)object, (String)KEY_NAME));
            int rarity = GsonHelper.m_13927_((JsonObject)object, (String)KEY_RARITY);
            ArrayList<ItemStorage> cureItems = new ArrayList<ItemStorage>();
            for (JsonElement jsonElement : object.getAsJsonArray(KEY_ITEMS)) {
                if (!jsonElement.isJsonObject()) continue;
                ItemStorage cureItem = new ItemStorage(jsonElement.getAsJsonObject());
                cureItem.setAmount(1);
                cureItems.add(cureItem);
            }
            diseases.add(new Disease(entry.getKey(), (Component)name, rarity, cureItems));
        }
        DISEASES = WeightedRandomList.m_146328_(diseases);
    }
}

